/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.utils.floodfill;

import earth.terrarium.adastra.common.blocks.SlidingDoorBlock;
import earth.terrarium.adastra.common.tags.ModBlockTags;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class FloodFill3D {
    private static final Direction[] DIRECTIONS = Direction.values();
    public static final SolidBlockPredicate TEST_FULL_SEAL = (level, pos, state, positions, queue, direction) -> {
        if (state.m_60795_()) {
            return true;
        }
        if (state.m_204336_(ModBlockTags.PASSES_FLOOD_FILL)) {
            return true;
        }
        if (state.m_204336_(ModBlockTags.BLOCKS_FLOOD_FILL)) {
            return false;
        }
        if (state.m_60838_((BlockGetter)level, pos)) {
            return false;
        }
        VoxelShape collisionShape = state.m_60812_((BlockGetter)level, pos);
        Block patt1354$temp = state.m_60734_();
        if (patt1354$temp instanceof SlidingDoorBlock) {
            SlidingDoorBlock block = (SlidingDoorBlock)patt1354$temp;
            collisionShape = block.m_5939_(state, (BlockGetter)level, pos, CollisionContext.m_82749_());
        }
        if (collisionShape.m_83281_()) {
            return true;
        }
        if (!FloodFill3D.isSideSolid(collisionShape, direction)) {
            return true;
        }
        if (!FloodFill3D.isFaceSturdy(collisionShape, direction) && !FloodFill3D.isFaceSturdy(collisionShape, direction.m_122424_())) {
            return true;
        }
        for (Direction dir : DIRECTIONS) {
            BlockPos adjacentPos;
            BlockState adjacentState;
            if (dir.m_122434_() == direction.m_122434_() || !(adjacentState = level.m_8055_(adjacentPos = pos.m_121945_(dir))).m_60795_()) continue;
            return true;
        }
        positions.add(pos.m_121878_());
        return false;
    };

    public static Set<BlockPos> run(Level level, BlockPos start, int limit, SolidBlockPredicate predicate, boolean retainOrder) {
        level.m_46473_().m_6180_("adastra-floodfill");
        LongLinkedOpenHashSet positions = retainOrder ? new LongLinkedOpenHashSet(limit) : new LongOpenHashSet(limit);
        LongArrayFIFOQueue queue = new LongArrayFIFOQueue(limit);
        queue.enqueue(start.m_121878_());
        while (!queue.isEmpty() && positions.size() < limit) {
            long packedPos = queue.dequeueLong();
            if (positions.contains(packedPos)) continue;
            positions.add(packedPos);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(BlockPos.m_121983_((long)packedPos), BlockPos.m_122008_((long)packedPos), BlockPos.m_122015_((long)packedPos));
            for (Direction direction : DIRECTIONS) {
                pos.m_122188_(packedPos);
                pos.m_122173_(direction);
                BlockState state = level.m_8055_((BlockPos)pos);
                if (!predicate.test(level, (BlockPos)pos, state, (LongSet)positions, queue, direction)) continue;
                queue.enqueue(pos.m_121878_());
            }
        }
        LinkedHashSet<BlockPos> result = retainOrder ? new LinkedHashSet(positions.size()) : new HashSet(positions.size());
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            result.add(BlockPos.m_122022_((long)pos));
        }
        level.m_46473_().m_7238_();
        return result;
    }

    private static boolean isSideSolid(VoxelShape collisionShape, Direction dir) {
        return switch (dir.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> FloodFill3D.isAxisCovered(collisionShape, Direction.Axis.Y, Direction.Axis.Z);
            case Direction.Axis.Y -> FloodFill3D.isAxisCovered(collisionShape, Direction.Axis.X, Direction.Axis.Z);
            case Direction.Axis.Z -> FloodFill3D.isAxisCovered(collisionShape, Direction.Axis.X, Direction.Axis.Y);
        };
    }

    private static boolean isAxisCovered(VoxelShape shape, Direction.Axis axis1, Direction.Axis axis2) {
        return shape.m_83288_(axis1) <= 0.0 && shape.m_83297_(axis1) >= 1.0 && shape.m_83288_(axis2) <= 0.0 && shape.m_83297_(axis2) >= 1.0;
    }

    private static boolean isFaceSturdy(VoxelShape collisionShape, Direction dir) {
        VoxelShape faceShape = collisionShape.m_83263_(dir);
        if (faceShape.m_83281_()) {
            return true;
        }
        List aabbs = faceShape.m_83299_();
        if (aabbs.isEmpty()) {
            return true;
        }
        return FloodFill3D.checkBounds((AABB)aabbs.get(0), dir.m_122434_());
    }

    private static boolean checkBounds(AABB bounds, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (bounds.f_82289_ <= 0.0 && bounds.f_82292_ >= 1.0 && bounds.f_82290_ <= 0.0 && bounds.f_82293_ >= 1.0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (bounds.f_82288_ <= 0.0 && bounds.f_82291_ >= 1.0 && bounds.f_82290_ <= 0.0 && bounds.f_82293_ >= 1.0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> bounds.f_82288_ <= 0.0 && bounds.f_82291_ >= 1.0 && bounds.f_82289_ <= 0.0 && bounds.f_82292_ >= 1.0;
        };
    }

    @FunctionalInterface
    public static interface SolidBlockPredicate {
        public boolean test(Level var1, BlockPos var2, BlockState var3, LongSet var4, LongArrayFIFOQueue var5, Direction var6);
    }
}

