/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.world.biome;

import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;

public class CratersBiomeSource
extends BiomeSource {
    public static final Codec<CratersBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Biome.f_47431_.fieldOf("default_biome").forGetter(source -> source.defaultBiome), (App)ExtraCodecs.m_144637_((Codec)DepthBiome.CODEC.listOf()).listOf().fieldOf("biomes").forGetter(source -> source.allowedBiomes), (App)Codec.doubleRange((double)Double.MIN_VALUE, (double)1.0).fieldOf("erosion_threshold").orElse((Object)0.5).forGetter(source -> source.erosionThreshold)).apply((Applicative)instance, CratersBiomeSource::new));
    private final Holder<Biome> defaultBiome;
    private final List<List<DepthBiome>> allowedBiomes;
    private final double erosionThreshold;

    public CratersBiomeSource(Holder<Biome> defaultBiome, List<List<DepthBiome>> biomeLists, double erosionThreshold) {
        this.defaultBiome = defaultBiome;
        this.allowedBiomes = biomeLists;
        this.erosionThreshold = erosionThreshold;
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    protected Stream<Holder<Biome>> m_274359_() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this.defaultBiome), this.allowedBiomes.stream().flatMap(Collection::stream).map(DepthBiome::biome)});
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler climateSampler) {
        if (this.allowedBiomes.isEmpty()) {
            return this.defaultBiome;
        }
        DensityFunction.SinglePointContext context = new DensityFunction.SinglePointContext(x, y, z);
        if (climateSampler.f_207848_().m_207386_((DensityFunction.FunctionContext)context) <= this.erosionThreshold) {
            return this.defaultBiome;
        }
        int cubeX = x - 8 >> 6;
        int cubeZ = z - 8 >> 6;
        int biomeIndex = (int)(((long)(cubeX * 31) ^ (long)cubeZ + Climate.m_186779_((float)((float)climateSampler.f_207846_().m_207386_((DensityFunction.FunctionContext)context)))) % (long)this.allowedBiomes.size());
        List<DepthBiome> biomes = this.allowedBiomes.get(biomeIndex);
        long depth = Climate.m_186779_((float)((float)climateSampler.f_207849_().m_207386_((DensityFunction.FunctionContext)context)));
        return biomes.stream().min(Comparator.comparingDouble(depthBiome -> depthBiome.depth().m_186825_(depth))).map(DepthBiome::biome).orElse(this.defaultBiome);
    }

    public record DepthBiome(Holder<Biome> biome, Climate.Parameter depth) {
        public static final Codec<DepthBiome> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Biome.f_47431_.fieldOf("biome").forGetter(DepthBiome::biome), (App)Climate.Parameter.f_186812_.fieldOf("depth").forGetter(DepthBiome::depth)).apply((Applicative)instance, DepthBiome::new));
    }
}

