/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.forge;

import com.mojang.brigadier.CommandDispatcher;
import earth.terrarium.adastra.AdAstra;
import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.client.forge.AdAstraClientForge;
import earth.terrarium.adastra.common.commands.AdAstraCommands;
import earth.terrarium.adastra.common.compat.create.CreateCompat;
import earth.terrarium.adastra.common.registry.ModEntityTypes;
import earth.terrarium.adastra.common.tags.ModBlockTags;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="ad_astra")
public class AdAstraForge {
    public AdAstraForge() {
        AdAstra.init();
        MinecraftForge.EVENT_BUS.addListener(AdAstraForge::onAddReloadListener);
        MinecraftForge.EVENT_BUS.addListener(AdAstraForge::onDatapackSync);
        MinecraftForge.EVENT_BUS.addListener(AdAstraForge::onServerTick);
        MinecraftForge.EVENT_BUS.addListener(AdAstraForge::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(AdAstraForge::onBlockPlace);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(AdAstraForge::onAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(AdAstraForge::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(AdAstraForge::onRegister);
        if (FMLEnvironment.dist.isClient()) {
            AdAstraClientForge.init();
        }
    }

    public static void onAddReloadListener(AddReloadListenerEvent event) {
        AdAstra.onAddReloadListener((ResourceLocation id, PreparableReloadListener listener) -> event.addListener(listener));
    }

    public static void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            AdAstra.onDatapackSync(event.getPlayer());
        } else {
            for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                AdAstra.onDatapackSync(player);
            }
        }
    }

    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            AdAstra.onServerTick(event.getServer());
        }
    }

    public static void onAttributes(EntityAttributeCreationEvent event) {
        ModEntityTypes.registerAttributes((entityType, attribute) -> event.put((EntityType)entityType.get(), ((AttributeSupplier.Builder)attribute.get()).m_22265_()));
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        AdAstra.postInit();
    }

    public static void onRegister(RegisterEvent event) {
        if (ModList.get().isLoaded("create")) {
            CreateCompat.init();
        }
    }

    private static void registerCommands(RegisterCommandsEvent event) {
        AdAstraCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Level level;
        LevelAccessor levelAccessor;
        if (event.getPlacedBlock().m_204336_(ModBlockTags.DESTROYED_IN_SPACE) && !event.getPlacedBlock().m_60823_() && (levelAccessor = event.getLevel()) instanceof Level && !OxygenApi.API.hasOxygen(level = (Level)levelAccessor, event.getPos())) {
            event.setCanceled(true);
        }
    }
}

