/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilScreenHandlerMixin {
    @Unique
    private final AtomicInteger resultCount = new AtomicInteger();

    @Inject(method={"updateResult"}, at={@At(value="RETURN")})
    private void afterUpdateResult(CallbackInfo info) {
        this.resultCount.set(((AnvilMenu)this).m_38853_(2).m_7993_().m_41613_());
    }

    @Redirect(method={"onTakeOutput"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/Inventory;setStack(ILnet/minecraft/item/ItemStack;)V", ordinal=0))
    private void removeItemsFromFirstInputSlot(Container inventory, int slot, ItemStack stack, @Share(value="resultCountSnapshot") LocalIntRef resultCountSnapshot) {
        resultCountSnapshot.set(this.resultCount.get());
        this.decrementOrRemove(inventory, slot, resultCountSnapshot.get());
    }

    @Redirect(method={"onTakeOutput"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/Inventory;setStack(ILnet/minecraft/item/ItemStack;)V", ordinal=3))
    private void removeItemsFromSecondInputSlot(Container inventory, int slot, ItemStack stack, @Share(value="resultCountSnapshot") LocalIntRef resultCountSnapshot) {
        this.decrementOrRemove(inventory, slot, resultCountSnapshot.get());
    }

    @Unique
    private void decrementOrRemove(Container inventory, int slot, int amount) {
        ItemStack currentStack = inventory.m_8020_(slot);
        if (currentStack.m_41613_() > amount) {
            ItemStack copy = currentStack.m_41777_();
            copy.m_41774_(amount);
            inventory.m_6836_(slot, copy);
            return;
        }
        inventory.m_6836_(slot, ItemStack.f_41583_);
    }

    @ModifyExpressionValue(method={"updateResult"}, at={@At(value="INVOKE", target="Lnet/minecraft/inventory/Inventory;getStack(I)Lnet/minecraft/item/ItemStack;", ordinal=0)})
    private ItemStack tweakFirstInputStack(ItemStack stack) {
        if (stack.m_41613_() > 1 && stack.m_150930_(Items.f_42690_)) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            return copy;
        }
        return stack;
    }

    @ModifyExpressionValue(method={"updateResult"}, at={@At(value="INVOKE", target="Lnet/minecraft/inventory/Inventory;getStack(I)Lnet/minecraft/item/ItemStack;", ordinal=1)})
    private ItemStack tweakSecondInputStack(ItemStack stack) {
        if (stack.m_41613_() > 1 && stack.m_150930_(Items.f_42690_)) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            return copy;
        }
        return stack;
    }
}

