/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Objects;
import me.roundaround.stackables.roundalib.config.ModConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class GuiUtil {
    public static int LABEL_COLOR = GuiUtil.genColorInt(1.0f, 1.0f, 1.0f);
    public static int ERROR_COLOR = GuiUtil.genColorInt(1.0f, 0.15f, 0.15f);
    public static int BACKGROUND_COLOR = GuiUtil.genColorInt(0.0f, 0.0f, 0.0f, 0.5f);
    public static int PADDING = 4;
    public static int SCROLLBAR_WIDTH = 6;
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    public static ResourceLocation getWidgetsTexture(ModConfig config) {
        return new ResourceLocation(config.getModId(), "textures/roundalib.png");
    }

    public static int getScaledWindowWidth() {
        return GuiUtil.getScaledWindowWidth(CLIENT);
    }

    public static int getScaledWindowWidth(Minecraft client) {
        return client.m_91268_().m_85445_();
    }

    public static int getScaledWindowHeight() {
        return GuiUtil.getScaledWindowHeight(CLIENT);
    }

    public static int getScaledWindowHeight(Minecraft client) {
        return client.m_91268_().m_85446_();
    }

    public static int getDisplayWidth() {
        return GuiUtil.getDisplayWidth(CLIENT);
    }

    public static int getDisplayWidth(Minecraft client) {
        return client.m_91268_().m_85443_();
    }

    public static int getDisplayHeight() {
        return GuiUtil.getDisplayHeight(CLIENT);
    }

    public static int getDisplayHeight(Minecraft client) {
        return client.m_91268_().m_85444_();
    }

    public static double getScaleFactor() {
        return GuiUtil.getScaleFactor(CLIENT);
    }

    public static double getScaleFactor(Minecraft client) {
        return client.m_91268_().m_85449_();
    }

    public static void renderInScissor(int x, int y, int width, int height, Runnable render) {
        GuiUtil.renderInScissor(CLIENT, x, y, width, height, render);
    }

    public static void renderInScissor(Minecraft client, int x, int y, int width, int height, Runnable render) {
        Screen currentScreen = GuiUtil.getCurrentScreen(client);
        if (currentScreen == null) {
            render.run();
        }
        int scissorLeft = x;
        int scissorTop = client.m_91268_().m_85444_() - (y + height);
        int scissorWidth = width;
        int scissorHeight = height;
        double scaleFactor = GuiUtil.getScaleFactor(client);
        scissorLeft = Mth.m_14107_((double)((double)scissorLeft * scaleFactor));
        scissorTop = Mth.m_14107_((double)((double)scissorTop * scaleFactor));
        scissorWidth = Mth.m_14165_((double)((double)scissorWidth * scaleFactor));
        scissorHeight = Mth.m_14165_((double)((double)scissorHeight * scaleFactor));
        RenderSystem.enableScissor((int)scissorLeft, (int)scissorTop, (int)scissorWidth, (int)scissorHeight);
        render.run();
        RenderSystem.disableScissor();
    }

    public static Screen getCurrentScreen() {
        return GuiUtil.getCurrentScreen(CLIENT);
    }

    public static Screen getCurrentScreen(Minecraft client) {
        return client.f_91080_;
    }

    public static void setScreen(Screen screen) {
        GuiUtil.setScreen(CLIENT, screen);
    }

    public static void setScreen(Minecraft client, Screen screen) {
        client.m_91152_(screen);
    }

    public static void playSoundEvent(SoundEvent soundEvent) {
        GuiUtil.playSoundEvent(CLIENT, soundEvent);
    }

    public static void playSoundEvent(Minecraft client, SoundEvent soundEvent) {
        client.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)soundEvent, (float)1.0f));
    }

    public static Font getTextRenderer() {
        return GuiUtil.CLIENT.f_91062_;
    }

    public static void drawTruncatedCenteredTextWithShadow(GuiGraphics drawContext, Font textRenderer, Component text, int x, int y, int color, int maxWidth) {
        Component trimmed = text;
        if (textRenderer.m_92852_((FormattedText)text) > maxWidth) {
            FormattedText ellipsis = FormattedText.m_130775_((String)"...");
            trimmed = FormattedText.m_130773_((FormattedText[])new FormattedText[]{textRenderer.m_92854_((FormattedText)text, maxWidth - textRenderer.m_92852_(ellipsis)), ellipsis});
        }
        drawContext.m_280364_(textRenderer, Language.m_128107_().m_5536_((FormattedText)trimmed), x, y, color);
    }

    public static void drawWrappedCenteredTextWithShadow(GuiGraphics drawContext, Font textRenderer, Component text, int x, int y, int color, int maxWidth) {
        List lines = textRenderer.m_92923_((FormattedText)text, maxWidth);
        int yCursor = y;
        for (FormattedCharSequence line : lines) {
            drawContext.m_280364_(textRenderer, line, x, yCursor, color);
            Objects.requireNonNull(textRenderer);
            yCursor += 9;
        }
    }

    public static void renderBackgroundInRegion(int brightness, int top, int bottom, int left, int right) {
        GuiUtil.renderBackgroundInRegion(brightness, top, bottom, left, right, 0.0, 0.0);
    }

    public static void renderBackgroundInRegion(int brightness, int top, int bottom, int left, int right, double offsetX, double offsetY) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Screen.f_279548_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_5483_((double)left, (double)bottom, 0.0).m_7421_((float)((long)left + Math.round(offsetX)) / 32.0f, (float)((long)bottom + Math.round(offsetY)) / 32.0f).m_6122_(brightness, brightness, brightness, 255).m_5752_();
        bufferBuilder.m_5483_((double)right, (double)bottom, 0.0).m_7421_((float)((long)right + Math.round(offsetX)) / 32.0f, (float)((long)bottom + Math.round(offsetY)) / 32.0f).m_6122_(brightness, brightness, brightness, 255).m_5752_();
        bufferBuilder.m_5483_((double)right, (double)top, 0.0).m_7421_((float)((long)right + Math.round(offsetX)) / 32.0f, (float)((long)top + Math.round(offsetY)) / 32.0f).m_6122_(brightness, brightness, brightness, 255).m_5752_();
        bufferBuilder.m_5483_((double)left, (double)top, 0.0).m_7421_((float)((long)left + Math.round(offsetX)) / 32.0f, (float)((long)top + Math.round(offsetY)) / 32.0f).m_6122_(brightness, brightness, brightness, 255).m_5752_();
        tessellator.m_85914_();
    }

    public static int genColorInt(float r, float g, float b) {
        return GuiUtil.genColorInt(r, g, b, 1.0f);
    }

    public static int genColorInt(float r, float g, float b, float a) {
        return (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }
}

