/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Objects;
import me.roundaround.stackables.roundalib.client.gui.GuiUtil;
import me.roundaround.stackables.roundalib.client.gui.widget.config.RoundaLibIconButtons;
import me.roundaround.stackables.roundalib.config.option.ConfigOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class ConfigOptionSubScreen<D, O extends ConfigOption<D, ?>>
extends Screen {
    protected static final int DARKEN_STRENGTH = 120;
    protected final Screen parent;
    protected final O configOption;
    protected final O workingCopy;
    protected final String modId;

    protected ConfigOptionSubScreen(Component title, Screen parent, O configOption) {
        super(title);
        this.parent = parent;
        this.configOption = configOption;
        this.workingCopy = ((ConfigOption)configOption).createWorkingCopy();
        this.modId = ((ConfigOption)configOption).getConfig().getModId();
    }

    protected void m_7856_() {
        this.m_7787_((GuiEventListener)RoundaLibIconButtons.resetButton(this.f_96543_ - 3 * (GuiUtil.PADDING + 13), this.f_96544_ - GuiUtil.PADDING - 13, this.workingCopy));
        this.m_7787_((GuiEventListener)RoundaLibIconButtons.discardButton(this.f_96543_ - 2 * (GuiUtil.PADDING + 13), this.f_96544_ - GuiUtil.PADDING - 13, ((ConfigOption)this.configOption).getConfig().getModId(), button -> this.discardAndExit()));
        this.m_7787_((GuiEventListener)RoundaLibIconButtons.saveButton(this.f_96543_ - GuiUtil.PADDING - 13, this.f_96544_ - GuiUtil.PADDING - 13, ((ConfigOption)this.configOption).getConfig().getModId(), button -> this.saveAndExit()));
    }

    public void m_7379_() {
        if (this.f_96541_ == null) {
            return;
        }
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 256: {
                this.discardAndExit();
                return true;
            }
            case 83: {
                if (Screen.m_96637_()) {
                    this.saveAndExit();
                    return true;
                }
            }
            case 82: {
                if (!Screen.m_96637_()) break;
                this.resetToDefault();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(drawContext, mouseX, mouseY, partialTicks);
        this.renderContent(drawContext, mouseX, mouseY, partialTicks);
        this.renderHelp(drawContext, mouseX, mouseY, partialTicks);
    }

    protected void renderBackground(GuiGraphics drawContext, int mouseX, int mouseY, float partialTicks) {
        if (this.parent == null) {
            this.renderTextureBackground(drawContext, mouseX, mouseY, partialTicks);
        } else {
            this.renderDarkenBackground(drawContext, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderTextureBackground(GuiGraphics drawContext, int mouseX, int mouseY, float partialTicks) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)f_279548_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_5483_(0.0, (double)this.f_96544_, 0.0).m_7421_(0.0f, (float)this.f_96544_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.f_96543_, (double)this.f_96544_, 0.0).m_7421_((float)this.f_96543_ / 32.0f, (float)this.f_96544_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.f_96543_, 0.0, 0.0).m_7421_((float)this.f_96543_ / 32.0f, 0.0f).m_6122_(64, 64, 64, 255).m_5752_();
        bufferBuilder.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, 0.0f).m_6122_(64, 64, 64, 255).m_5752_();
        tessellator.m_85914_();
    }

    protected void renderDarkenBackground(GuiGraphics drawContext, int mouseX, int mouseY, float partialTicks) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_(0.0, (double)this.f_96544_, 0.0).m_6122_(0, 0, 0, 120).m_5752_();
        bufferBuilder.m_5483_((double)this.f_96543_, (double)this.f_96544_, 0.0).m_6122_(0, 0, 0, 120).m_5752_();
        bufferBuilder.m_5483_((double)this.f_96543_, 0.0, 0.0).m_6122_(0, 0, 0, 120).m_5752_();
        bufferBuilder.m_5483_(0.0, 0.0, 0.0).m_6122_(0, 0, 0, 120).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    protected void renderContent(GuiGraphics drawContext, int mouseX, int mouseY, float partialTicks) {
        drawContext.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 17, GuiUtil.LABEL_COLOR);
        this.m_6702_().forEach(child -> {
            if (child instanceof Renderable) {
                ((Renderable)child).m_88315_(drawContext, mouseX, mouseY, partialTicks);
            }
        });
    }

    protected void renderHelp(GuiGraphics drawContext, int mouseX, int mouseY, float partialTicks) {
        if (ConfigOptionSubScreen.m_96638_()) {
            this.renderHelpExpanded(drawContext, mouseX, mouseY, partialTicks);
        } else {
            this.renderHelpPrompt(drawContext, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderHelpPrompt(GuiGraphics drawContext, int mouseX, int mouseY, float partialTicks) {
        this.renderHelpLines(drawContext, this.getHelpShort(mouseX, mouseY, partialTicks));
    }

    protected void renderHelpExpanded(GuiGraphics drawContext, int mouseX, int mouseY, float partialTicks) {
        this.renderHelpLines(drawContext, this.getHelpLong(mouseX, mouseY, partialTicks));
    }

    private void renderHelpLines(GuiGraphics drawContext, List<Component> lines) {
        this.renderHelpLines(drawContext, lines, false);
    }

    private void renderHelpLines(GuiGraphics drawContext, List<Component> lines, boolean offsetForIcon) {
        Objects.requireNonNull(this.f_96547_);
        int n = lines.size() - 1;
        Objects.requireNonNull(this.f_96547_);
        int startingOffset = this.f_96544_ - 4 - 9 - n * (9 + 2);
        for (int i = 0; i < lines.size(); ++i) {
            Objects.requireNonNull(this.f_96547_);
            drawContext.m_280430_(this.f_96547_, lines.get(i), 4, startingOffset + i * (9 + 2), GuiUtil.LABEL_COLOR);
        }
    }

    protected List<Component> getHelpShort(int mouseX, int mouseY, float partialTicks) {
        return List.of(Component.m_237115_((String)(this.modId + ".roundalib.help.short")));
    }

    protected List<Component> getHelpLong(int mouseX, int mouseY, float partialTicks) {
        return List.of(Component.m_237115_((String)(this.modId + ".roundalib.help.cancel")), Minecraft.f_91002_ ? Component.m_237115_((String)(this.modId + ".roundalib.help.save.mac")) : Component.m_237115_((String)(this.modId + ".roundalib.help.save.win")), Minecraft.f_91002_ ? Component.m_237115_((String)(this.modId + ".roundalib.help.reset.mac")) : Component.m_237115_((String)(this.modId + ".roundalib.help.reset.win")));
    }

    protected void setValue(D value) {
        ((ConfigOption)this.workingCopy).setValue(value);
    }

    protected D getValue() {
        return ((ConfigOption)this.workingCopy).getValue();
    }

    protected void resetToDefault() {
        ((ConfigOption)this.workingCopy).resetToDefault();
    }

    protected boolean isDirty() {
        return ((ConfigOption)this.workingCopy).isDirty();
    }

    protected void commitValueToConfig() {
        ((ConfigOption)this.configOption).setValue(this.getValue());
    }

    protected void discardAndExit() {
        this.m_7379_();
    }

    protected void saveAndExit() {
        this.commitValueToConfig();
        this.m_7379_();
    }
}

