/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import me.roundaround.stackables.roundalib.client.gui.GuiUtil;
import me.roundaround.stackables.roundalib.client.gui.screen.ConfigOptionSubScreen;
import me.roundaround.stackables.roundalib.client.gui.widget.IconButtonWidget;
import me.roundaround.stackables.roundalib.client.gui.widget.config.RoundaLibIconButtons;
import me.roundaround.stackables.roundalib.config.option.PositionConfigOption;
import me.roundaround.stackables.roundalib.config.value.Position;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class PositionEditScreen
extends ConfigOptionSubScreen<Position, PositionConfigOption> {
    protected static final Position CROSSHAIR_UV = new Position(0, 247);
    protected static final int CROSSHAIR_SIZE = 9;
    private boolean inverseX = false;
    private boolean inverseY = false;
    private IconButtonWidget upButton;
    private IconButtonWidget leftButton;
    private IconButtonWidget rightButton;
    private IconButtonWidget downButton;

    protected PositionEditScreen(Component title, Screen parent, PositionConfigOption configOption) {
        this(title, parent, configOption, false, false);
    }

    protected PositionEditScreen(Component title, Screen parent, PositionConfigOption configOption, boolean invertX, boolean invertY) {
        super(title, parent, configOption);
        this.inverseX = invertX;
        this.inverseY = invertY;
    }

    @Override
    protected void m_7856_() {
        int startX = this.f_96543_ - GuiUtil.PADDING;
        int startY = this.f_96544_ - GuiUtil.PADDING - 13 - GuiUtil.PADDING;
        this.upButton = (IconButtonWidget)this.m_7787_((GuiEventListener)RoundaLibIconButtons.upButton(startX - 26 - GuiUtil.PADDING, startY - 39 - 2 * GuiUtil.PADDING, this.modId, button -> this.moveUp()));
        this.leftButton = (IconButtonWidget)this.m_7787_((GuiEventListener)RoundaLibIconButtons.leftButton(startX - 39 - 2 * GuiUtil.PADDING, startY - 26 - GuiUtil.PADDING, this.modId, button -> this.moveLeft()));
        this.rightButton = (IconButtonWidget)this.m_7787_((GuiEventListener)RoundaLibIconButtons.rightButton(startX - 13, startY - 26 - GuiUtil.PADDING, this.modId, button -> this.moveRight()));
        this.downButton = (IconButtonWidget)this.m_7787_((GuiEventListener)RoundaLibIconButtons.downButton(startX - 26 - GuiUtil.PADDING, startY - 13, this.modId, button -> this.moveDown()));
        super.m_7856_();
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 265: {
                this.moveUp();
                return true;
            }
            case 264: {
                this.moveDown();
                return true;
            }
            case 263: {
                this.moveLeft();
                return true;
            }
            case 262: {
                this.moveRight();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    protected List<Component> getHelpLong(int mouseX, int mouseY, float partialTicks) {
        ArrayList<Component> full = new ArrayList<Component>();
        full.add((Component)Component.m_237115_((String)(this.modId + ".roundalib.help.position.single")));
        full.add((Component)Component.m_237115_((String)(this.modId + ".roundalib.help.position.multi")));
        full.addAll(super.getHelpLong(mouseX, mouseY, partialTicks));
        return full;
    }

    @Override
    protected void renderContent(GuiGraphics drawContext, int mouseX, int mouseY, float partialTicks) {
        super.renderContent(drawContext, mouseX, mouseY, partialTicks);
        ResourceLocation texture = new ResourceLocation(this.modId, "textures/roundalib.png");
        int left = this.upButton.m_252754_() + GuiUtil.PADDING / 2;
        int top = this.leftButton.m_252907_() + GuiUtil.PADDING / 2;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.applyModelViewMatrix();
        PoseStack matrixStack = drawContext.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, 0.0f, 50.0f);
        drawContext.m_280218_(texture, left, top, CROSSHAIR_UV.x(), CROSSHAIR_UV.y(), 9, 9);
        matrixStack.m_85849_();
    }

    protected int getMoveAmount() {
        return PositionEditScreen.m_96638_() ? 8 : 1;
    }

    protected void moveUp() {
        this.setValue(((Position)this.getValue()).movedUp(this.getMoveAmount() * (this.inverseY ? -1 : 1)));
    }

    protected void moveDown() {
        this.setValue(((Position)this.getValue()).movedDown(this.getMoveAmount() * (this.inverseY ? -1 : 1)));
    }

    protected void moveLeft() {
        this.setValue(((Position)this.getValue()).movedLeft(this.getMoveAmount() * (this.inverseX ? -1 : 1)));
    }

    protected void moveRight() {
        this.setValue(((Position)this.getValue()).movedRight(this.getMoveAmount() * (this.inverseX ? -1 : 1)));
    }
}

