/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui.widget;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class FloatSliderWidget
extends AbstractSliderButton {
    protected final float min;
    protected final float max;
    protected final float step;
    protected final Consumer<Float> valueChanged;
    protected final Function<Float, Component> formatter;
    private float floatValue;

    public FloatSliderWidget(int x, int y, int width, int height, float min, float max, float step, float value, Consumer<Float> valueChanged) {
        this(x, y, width, height, min, max, step, value, valueChanged, v -> Component.m_130674_((String)v.toString()));
    }

    public FloatSliderWidget(int x, int y, int width, int height, float min, float max, float step, float value, Consumer<Float> valueChanged, Function<Float, Component> formatter) {
        super(x, y, width, height, formatter.apply(Float.valueOf(value)), FloatSliderWidget.valueToSlider(value, min, max));
        this.min = min;
        this.max = max;
        this.step = step;
        this.valueChanged = valueChanged;
        this.formatter = formatter;
        this.floatValue = value;
    }

    public void setFloatValue(float floatValue) {
        this.floatValue = floatValue;
        this.f_93577_ = FloatSliderWidget.valueToSlider(this.floatValue, this.min, this.max);
        this.m_5695_();
    }

    public float getFloatValue() {
        return this.floatValue;
    }

    protected void m_5695_() {
        this.m_93666_(this.formatter.apply(Float.valueOf(this.floatValue)));
    }

    protected void m_5697_() {
        this.floatValue = FloatSliderWidget.sliderToValue(this.f_93577_, this.min, this.max);
        this.valueChanged.accept(Float.valueOf(this.floatValue));
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.setFloatValue(this.floatValue + (float)((int)Math.signum(amount)) * this.step);
            this.m_5697_();
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void m_87963_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.f_93622_ = this.f_93622_ && this.f_93623_;
        super.m_87963_(drawContext, mouseX, mouseY, delta);
    }

    protected static double valueToSlider(float value, float min, float max) {
        if (min == max) {
            return 0.0;
        }
        return Mth.m_14008_((double)((double)(value - min) / (double)(max - min)), (double)0.0, (double)1.0);
    }

    protected static float sliderToValue(double slider, float min, float max) {
        return (float)Mth.m_14008_((double)(slider * (double)(max - min) + (double)min), (double)min, (double)max);
    }
}

