/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class IconButtonWidget
extends Button {
    protected static final int DEFAULT_SIZE = 20;
    protected static final int DEFAULT_TEXTURE_SIZE = 256;
    protected final int iconU;
    protected final int iconV;
    protected final int textureSize;
    protected final ResourceLocation texture;

    protected IconButtonWidget(int x, int y, int width, int height, int iconU, int iconV, int textureSize, ResourceLocation texture, Button.OnPress onPress, Tooltip tooltip) {
        super(x, y, width, height, (Component)Component.m_237119_(), onPress, f_252438_);
        this.iconU = iconU;
        this.iconV = iconV;
        this.textureSize = textureSize;
        this.texture = texture;
        if (tooltip != null) {
            this.m_257544_(tooltip);
        }
    }

    public void m_87963_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        super.m_87963_(drawContext, mouseX, mouseY, delta);
        float brightness = this.f_93623_ ? 1.0f : 0.6f;
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        drawContext.m_280163_(this.texture, this.m_252754_(), this.m_252907_(), (float)this.iconU, (float)this.iconV, this.f_93618_, this.f_93619_, this.textureSize, this.textureSize);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static Builder builder(ResourceLocation texture, Button.OnPress onPress) {
        return new Builder(texture, onPress);
    }

    public static class Builder {
        private final ResourceLocation texture;
        private final Button.OnPress onPress;
        private int size = 20;
        private int x;
        private int y;
        private int iconU;
        private int iconV;
        private int textureSize = 256;
        private boolean autoCalculateUV = false;
        private int textureIndex;
        private int autoCalculateStartX = 0;
        private int autoCalculateStartY = 0;
        private Tooltip tooltip = null;

        public Builder(ResourceLocation texture, Button.OnPress onPress) {
            this.texture = texture;
            this.onPress = onPress;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder uv(int u, int v) {
            this.iconU = u;
            this.iconV = v;
            return this;
        }

        public Builder textureSize(int textureSize) {
            this.textureSize = textureSize;
            return this;
        }

        public Builder autoCalculateUV(int textureIndex) {
            this.autoCalculateUV = true;
            this.textureIndex = textureIndex;
            return this;
        }

        public Builder autoCalculateUV(int textureIndex, int startX, int startY) {
            this.autoCalculateStartX = startX;
            this.autoCalculateStartY = startY;
            return this.autoCalculateUV(textureIndex);
        }

        public Builder tooltip(Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder tooltip(Component tooltip) {
            return this.tooltip(Tooltip.m_257550_((Component)tooltip));
        }

        public IconButtonWidget build() {
            int u = this.iconU;
            int v = this.iconV;
            if (this.autoCalculateUV) {
                int workableWidth = this.textureSize - this.autoCalculateStartX;
                int iconsPerRow = workableWidth / this.size;
                u = this.autoCalculateStartX + this.textureIndex % iconsPerRow * this.size;
                v = this.autoCalculateStartY + this.textureIndex / iconsPerRow * this.size;
            }
            return new IconButtonWidget(this.x, this.y, this.size, this.size, u, v, this.textureSize, this.texture, this.onPress, this.tooltip);
        }
    }
}

