/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui.widget;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class IntSliderWidget
extends AbstractSliderButton {
    protected final int min;
    protected final int max;
    protected final int step;
    protected final Consumer<Integer> valueChanged;
    protected final Function<Integer, Component> formatter;
    private int intValue;

    public IntSliderWidget(int x, int y, int width, int height, int min, int max, int step, int value, Consumer<Integer> valueChanged) {
        this(x, y, width, height, min, max, step, value, valueChanged, v -> Component.m_130674_((String)v.toString()));
    }

    public IntSliderWidget(int x, int y, int width, int height, int min, int max, int step, int value, Consumer<Integer> valueChanged, Function<Integer, Component> formatter) {
        super(x, y, width, height, formatter.apply(value), IntSliderWidget.valueToSlider(value, min, max));
        this.min = min;
        this.max = max;
        this.step = step;
        this.valueChanged = valueChanged;
        this.formatter = formatter;
        this.intValue = value;
    }

    public void setIntValue(int intValue) {
        this.intValue = intValue;
        this.f_93577_ = IntSliderWidget.valueToSlider(this.intValue, this.min, this.max);
        this.m_5695_();
    }

    public int getIntValue() {
        return this.intValue;
    }

    protected void m_5695_() {
        this.m_93666_(this.formatter.apply(this.intValue));
    }

    protected void m_5697_() {
        this.intValue = IntSliderWidget.sliderToValue(this.f_93577_, this.min, this.max);
        this.valueChanged.accept(this.intValue);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.setIntValue(this.intValue + (int)Math.signum(amount) * this.step);
            this.m_5697_();
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void m_87963_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.f_93622_ = this.f_93622_ && this.f_93623_;
        super.m_87963_(drawContext, mouseX, mouseY, delta);
    }

    protected static double valueToSlider(int value, int min, int max) {
        if (min == max) {
            return 0.0;
        }
        return Mth.m_14008_((double)((double)(value - min) / (double)(max - min)), (double)0.0, (double)1.0);
    }

    protected static int sliderToValue(double slider, int min, int max) {
        return Mth.m_14045_((int)((int)Math.round(slider * (double)(max - min) + (double)min)), (int)min, (int)max);
    }
}

