/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui.widget;

import me.roundaround.stackables.roundalib.client.gui.DrawableBuilder;
import me.roundaround.stackables.roundalib.client.gui.GuiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class LabelWidget
implements Renderable {
    public static final int HEIGHT_WITH_PADDING = 13;
    public static final int PADDING = 2;
    private int posX;
    private int posY;
    private final Alignment alignmentH;
    private final Alignment alignmentV;
    private final boolean showBackground;
    private final boolean showTextShadow;
    private final boolean shiftForPadding;
    private final Font textRenderer;
    private Component text;
    private int textWidth;
    private float left;
    private float right;
    private float top;
    private float bottom;

    private LabelWidget(Minecraft client, Component text, int posX, int posY, Alignment alignmentH, Alignment alignmentV, boolean showBackground, boolean showTextShadow, boolean shiftForPadding) {
        this.posX = posX;
        this.posY = posY;
        this.alignmentH = alignmentH;
        this.alignmentV = alignmentV;
        this.showBackground = showBackground;
        this.showTextShadow = showTextShadow;
        this.shiftForPadding = shiftForPadding;
        this.textRenderer = client.f_91062_;
        this.setText(text);
    }

    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if (this.showBackground) {
            drawContext.m_280509_(Mth.m_14143_((float)this.left) - 2, Mth.m_14143_((float)this.top) - 1, Mth.m_14167_((float)this.right) + 2, Mth.m_14167_((float)this.bottom) + 1, GuiUtil.BACKGROUND_COLOR);
        }
        if (this.showTextShadow) {
            drawContext.m_280430_(this.textRenderer, this.text, Math.round(this.left + 0.5f), Math.round(this.top + 1.0f), -1);
        } else {
            drawContext.m_280614_(this.textRenderer, this.text, Math.round(this.left + 0.5f), Math.round(this.top + 1.0f), GuiUtil.LABEL_COLOR, false);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        int pixelLeft = Mth.m_14143_((float)this.left) - (this.showBackground ? 2 : 0);
        int pixelRight = Mth.m_14167_((float)this.right) + (this.showBackground ? 2 : 0);
        int pixelTop = Mth.m_14143_((float)this.top) - (this.showBackground ? 1 : 0);
        int pixelBottom = Mth.m_14167_((float)this.bottom) + (this.showBackground ? 1 : 0);
        return mouseX >= (double)pixelLeft && mouseY >= (double)pixelTop && mouseX < (double)pixelRight && mouseY < (double)pixelBottom;
    }

    public void setText(Component text) {
        if (this.text != null && text.getString().equals(this.text.getString())) {
            return;
        }
        this.text = text;
        this.textWidth = this.textRenderer.m_92852_((FormattedText)text);
        this.calculateBounds();
    }

    public void setPosX(int posX) {
        this.posX = posX;
        this.calculateBounds();
    }

    public void setPosY(int posY) {
        this.posY = posY;
        this.calculateBounds();
    }

    public void setPos(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
        this.calculateBounds();
    }

    public int getLeft() {
        return Mth.m_14143_((float)this.left);
    }

    public int getRight() {
        return Mth.m_14167_((float)this.right);
    }

    public int getTop() {
        return Mth.m_14143_((float)this.top);
    }

    public int getBottom() {
        return Mth.m_14167_((float)this.bottom);
    }

    private void calculateBounds() {
        switch (this.alignmentH) {
            case CENTER: {
                this.left = (float)this.posX - (float)this.textWidth / 2.0f;
                this.right = (float)this.posX + (float)this.textWidth / 2.0f;
                break;
            }
            case END: {
                this.left = this.posX - this.textWidth;
                this.right = this.posX;
                break;
            }
            default: {
                this.left = this.posX;
                this.right = this.posX + this.textWidth;
            }
        }
        switch (this.alignmentV) {
            case START: {
                this.top = this.posY;
                this.bottom = this.posY + 10;
                break;
            }
            case END: {
                this.top = this.posY - 10;
                this.bottom = this.posY;
                break;
            }
            default: {
                this.top = (float)this.posY - 5.0f;
                this.bottom = (float)this.posY + 5.0f;
            }
        }
        if (this.shiftForPadding) {
            this.left += (float)(this.alignmentH.getShiftOffset() * 2);
            this.right += (float)(this.alignmentH.getShiftOffset() * 2);
            this.top += (float)this.alignmentV.getShiftOffset();
            this.bottom += (float)this.alignmentV.getShiftOffset();
        }
    }

    public static Builder builder(Minecraft client, Component text, int posX, int posY) {
        return new Builder(client, text, posX, posY);
    }

    public static enum Alignment {
        START(1),
        CENTER(0),
        END(-1);

        private final int shiftOffset;

        private Alignment(int shiftOffset) {
            this.shiftOffset = shiftOffset;
        }

        public int getShiftOffset() {
            return this.shiftOffset;
        }
    }

    public static class Builder
    implements DrawableBuilder<LabelWidget> {
        private final Minecraft client;
        private final Component text;
        private final int posX;
        private final int posY;
        private Alignment alignmentH = Alignment.START;
        private Alignment alignmentV = Alignment.CENTER;
        private boolean showBackground = true;
        private boolean showTextShadow = false;
        private boolean shiftForPadding = false;

        public Builder(Minecraft client, Component text, int posX, int posY) {
            this.client = client;
            this.text = text;
            this.posX = posX;
            this.posY = posY;
        }

        public Builder justifiedLeft() {
            this.alignmentH = Alignment.START;
            return this;
        }

        public Builder justifiedCenter() {
            this.alignmentH = Alignment.CENTER;
            return this;
        }

        public Builder justifiedRight() {
            this.alignmentH = Alignment.END;
            return this;
        }

        public Builder alignedTop() {
            this.alignmentV = Alignment.START;
            return this;
        }

        public Builder alignedMiddle() {
            this.alignmentV = Alignment.CENTER;
            return this;
        }

        public Builder alignedBottom() {
            this.alignmentV = Alignment.END;
            return this;
        }

        public Builder hideBackground() {
            this.showBackground = false;
            return this;
        }

        public Builder showTextShadow() {
            this.showTextShadow = true;
            return this;
        }

        public Builder shiftForPadding() {
            this.shiftForPadding = true;
            return this;
        }

        @Override
        public LabelWidget build() {
            return new LabelWidget(this.client, this.text, this.posX, this.posY, this.alignmentH, this.alignmentV, this.showBackground, this.showTextShadow, this.shiftForPadding);
        }
    }
}

