/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import me.roundaround.stackables.roundalib.client.gui.GuiUtil;
import me.roundaround.stackables.roundalib.client.gui.widget.config.ConfigListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public abstract class VariableHeightListWidget<E extends Entry<E>>
extends AbstractContainerEventHandler
implements Renderable,
NarratableEntry {
    protected final Minecraft client;
    protected final PositionalLinkedList<E> entries;
    protected final int contentPadding;
    protected final int rowPadding;
    protected int left;
    protected int top;
    protected int right;
    protected int bottom;
    protected int width;
    protected int height;
    protected E hoveredEntry;
    protected double scrollUnit;
    protected boolean autoCalculateScrollUnit = true;
    private double scrollAmount;
    private boolean scrolling;

    public VariableHeightListWidget(Minecraft client, int left, int top, int width, int height) {
        this(client, left, top, width, height, GuiUtil.PADDING, GuiUtil.PADDING);
    }

    public VariableHeightListWidget(Minecraft client, int left, int top, int width, int height, int contentPadding, int rowPadding) {
        this.client = client;
        this.left = left;
        this.right = left + width;
        this.top = top;
        this.bottom = top + height;
        this.width = width;
        this.height = height;
        this.contentPadding = contentPadding;
        this.rowPadding = rowPadding;
        this.entries = new PositionalLinkedList(this.rowPadding);
    }

    public <T extends E> T addEntry(T entry) {
        this.entries.add(entry);
        return entry;
    }

    public void clearEntries() {
        this.entries.clear();
    }

    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.hoveredEntry = this.m_5953_(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        this.renderBackground(drawContext, delta);
        drawContext.m_280588_(this.left, this.top, this.right, this.bottom);
        this.renderList(drawContext, mouseX, mouseY, delta);
        this.renderScrollBar(drawContext, mouseX, mouseY, delta);
        drawContext.m_280618_();
    }

    protected void renderList(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        for (int i = 0; i < this.entries.size(); ++i) {
            this.renderEntry(drawContext, i, mouseX, mouseY, delta);
        }
    }

    protected void renderEntry(GuiGraphics drawContext, int index, int mouseX, int mouseY, float delta) {
        E entry = this.entries.get(index);
        double scrollAmount = this.getScrollAmount();
        double scrolledTop = (double)((Entry)((Object)entry)).getTop() - scrollAmount;
        double scrolledBottom = (double)(((Entry)((Object)entry)).getTop() + ((Entry)((Object)entry)).getHeight()) - scrollAmount;
        if (scrolledBottom < (double)this.top || scrolledTop > (double)this.bottom) {
            return;
        }
        ((Entry)((Object)entry)).render(drawContext, index, scrollAmount, mouseX, mouseY, delta);
    }

    protected void renderScrollBar(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        int maxScroll = this.getMaxScroll();
        if (maxScroll <= 0) {
            return;
        }
        int scrollbarLeft = this.getScrollbarPositionX();
        int scrollbarRight = scrollbarLeft + GuiUtil.SCROLLBAR_WIDTH;
        RenderSystem.setShader(GameRenderer::m_172811_);
        int handleHeight = (int)((float)this.height * (float)this.height / (float)this.getContentHeight());
        handleHeight = Mth.m_14045_((int)handleHeight, (int)32, (int)(this.height - 8));
        int handleTop = (int)this.scrollAmount * (this.height - handleHeight) / maxScroll + this.top;
        if (handleTop < this.top) {
            handleTop = this.top;
        }
        drawContext.m_280509_(scrollbarLeft, this.top, scrollbarRight, this.bottom, GuiUtil.genColorInt(0.0f, 0.0f, 0.0f));
        drawContext.m_280509_(scrollbarLeft, handleTop, scrollbarRight, handleTop + handleHeight, GuiUtil.genColorInt(0.5f, 0.5f, 0.5f));
        drawContext.m_280509_(scrollbarLeft, handleTop, scrollbarRight - 1, handleTop + handleHeight - 2, GuiUtil.genColorInt(0.75f, 0.75f, 0.75f));
    }

    protected void renderBackground(GuiGraphics drawContext, float delta) {
        Screen parent = this.client.f_91080_;
        int screenWidth = parent != null ? parent.f_96543_ : this.width;
        GuiUtil.renderBackgroundInRegion(32, this.top, this.bottom, 0, screenWidth, 0.0, (int)this.scrollAmount);
        this.renderHorizontalShadows(drawContext, delta);
    }

    protected void renderHorizontalShadows(GuiGraphics drawContext, float delta) {
        Screen parent = this.client.f_91080_;
        int screenWidth = parent != null ? parent.f_96543_ : this.width;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_(0.0, (double)(this.top + this.contentPadding), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferBuilder.m_5483_((double)screenWidth, (double)(this.top + this.contentPadding), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferBuilder.m_5483_((double)screenWidth, (double)this.top, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_5483_(0.0, (double)this.top, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_5483_(0.0, (double)this.bottom, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_5483_((double)screenWidth, (double)this.bottom, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_5483_((double)screenWidth, (double)(this.bottom - this.contentPadding), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferBuilder.m_5483_(0.0, (double)(this.bottom - this.contentPadding), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public ScreenRectangle m_264198_() {
        return new ScreenRectangle(this.left, this.top, this.width, this.height);
    }

    public E getFocused() {
        return (E)((Object)((Entry)super.m_7222_()));
    }

    public void m_7522_(GuiEventListener focused) {
        super.m_7522_(focused);
        E entry = this.getFocused();
        if (entry == null) {
            return;
        }
        if (this.client.m_264529_().m_264505_()) {
            this.ensureVisible(entry);
        }
    }

    public ComponentPath m_264064_(FocusNavigationEvent navigation) {
        ComponentPath path;
        if (this.entries.isEmpty()) {
            return null;
        }
        if (!(navigation instanceof FocusNavigationEvent.ArrowNavigation)) {
            return super.m_264064_(navigation);
        }
        FocusNavigationEvent.ArrowNavigation arrow = (FocusNavigationEvent.ArrowNavigation)navigation;
        Object entry = this.getFocused();
        if (arrow.f_263812_().m_264093_() == ScreenAxis.HORIZONTAL && entry != null) {
            return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)((Entry)((Object)entry)).m_264064_(navigation));
        }
        int index = -1;
        ScreenDirection direction = arrow.f_263812_();
        if (entry != null) {
            index = entry.m_6702_().indexOf(((Entry)((Object)entry)).m_7222_());
        }
        if (index == -1) {
            switch (direction) {
                case LEFT: {
                    index = Integer.MAX_VALUE;
                    direction = ScreenDirection.DOWN;
                    break;
                }
                case RIGHT: {
                    index = 0;
                    direction = ScreenDirection.DOWN;
                    break;
                }
                default: {
                    index = 0;
                }
            }
        }
        do {
            if ((entry = this.getNeighboringEntry(direction, element -> !element.m_6702_().isEmpty())) != null) continue;
            return null;
        } while ((path = ((Entry)((Object)entry)).getNavigationPath((FocusNavigationEvent)arrow, index)) == null);
        return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)path);
    }

    protected E getNeighboringEntry(ScreenDirection direction) {
        return (E)((Object)this.getNeighboringEntry(direction, entry -> true));
    }

    protected E getNeighboringEntry(ScreenDirection direction, Predicate<E> predicate) {
        return this.getNeighboringEntry(direction, predicate, this.getFocused());
    }

    protected E getNeighboringEntry(ScreenDirection direction, Predicate<E> predicate, E focused) {
        int delta;
        if (this.entries.isEmpty()) {
            return null;
        }
        switch (direction) {
            case UP: {
                int n = -1;
                break;
            }
            case DOWN: {
                int n = 1;
                break;
            }
            default: {
                int n = delta = 0;
            }
        }
        if (delta == 0) {
            return null;
        }
        int index = focused == null ? (delta > 0 ? 0 : this.entries.size() - 1) : this.entries.indexOf(focused) + delta;
        for (int i = index; i >= 0 && i < this.entries.size(); i += delta) {
            E entry = this.entries.get(i);
            if (!predicate.test(entry)) continue;
            return entry;
        }
        return null;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.entries.asList();
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        if (this.m_93696_()) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        return this.hoveredEntry != null ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    protected E getHoveredEntry() {
        return this.hoveredEntry;
    }

    protected void appendNarrations(NarrationElementOutput builder, E entry) {
        int i;
        List<E> list = this.entries.asList();
        if (list.size() > 1 && (i = list.indexOf(entry)) != -1) {
            builder.m_169146_(NarratedElementType.POSITION, (Component)Component.m_237110_((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    public void m_142291_(NarrationElementOutput builder) {
        E hovered = this.getHoveredEntry();
        if (hovered != null) {
            ((Entry)((Object)hovered)).appendNarrations(builder.m_142047_());
            this.appendNarrations(builder, hovered);
        } else {
            E focused = this.getFocused();
            if (focused != null) {
                ((Entry)((Object)focused)).appendNarrations(builder.m_142047_());
                this.appendNarrations(builder, focused);
            }
        }
        builder.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.component_list.usage"));
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= (double)this.left && mouseX <= (double)this.right && mouseY >= (double)this.top && mouseY <= (double)this.bottom;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        E entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null && entry.m_6375_(mouseX, mouseY, button)) {
            E focused = this.getFocused();
            if (focused != entry && focused != null) {
                ((Entry)((Object)focused)).m_7522_(null);
            }
            this.m_7522_((GuiEventListener)entry);
            this.m_7897_(true);
            return true;
        }
        return this.scrolling;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.getFocused() != null) {
            this.getFocused().m_6348_(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.top) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)this.bottom) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double d = Math.max(1, this.getMaxScroll());
                int i = this.height;
                int j = Mth.m_14045_((int)((int)((float)(i * i) / (float)this.entries.totalHeight)), (int)32, (int)(i - 8));
                double e = Math.max(1.0, d / (double)(i - j));
                this.setScrollAmount(this.getScrollAmount() + deltaY * e);
            }
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.setScrollAmount(this.getScrollAmount() - amount * this.getScrollUnit());
        return true;
    }

    protected E getEntryAtPosition(double x, double y) {
        if (x < (double)this.getContentLeft() || x > (double)this.getContentRight()) {
            return null;
        }
        if (y < (double)this.top || y > (double)this.bottom) {
            return null;
        }
        return this.entries.getEntryAtPosition(y + this.scrollAmount);
    }

    protected void ensureVisible(E entry) {
        int scrolledTop = ((Entry)((Object)entry)).getTop() - (int)this.scrollAmount;
        if (scrolledTop < this.top + this.contentPadding) {
            this.scroll(scrolledTop - this.top - this.contentPadding);
            return;
        }
        int scrolledBottom = ((Entry)((Object)entry)).getTop() + ((Entry)((Object)entry)).getHeight() - (int)this.scrollAmount;
        if (scrolledBottom > this.bottom - this.contentPadding) {
            this.scroll(scrolledBottom - this.bottom + this.contentPadding);
        }
    }

    protected int getContentHeight() {
        return this.entries.totalHeight + this.contentPadding * 2;
    }

    protected int getContentWidth() {
        return this.width - (GuiUtil.SCROLLBAR_WIDTH + this.contentPadding) * 2;
    }

    protected int getContentLeft() {
        return this.left + GuiUtil.SCROLLBAR_WIDTH + this.contentPadding;
    }

    protected int getContentRight() {
        return this.right - GuiUtil.SCROLLBAR_WIDTH - this.contentPadding;
    }

    protected int getScrollbarPositionX() {
        return this.right - GuiUtil.SCROLLBAR_WIDTH;
    }

    private void scroll(int amount) {
        this.setScrollAmount(this.getScrollAmount() + (double)amount);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double amount) {
        this.scrollAmount = Mth.m_14008_((double)amount, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getContentHeight() - this.height);
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPositionX() && mouseX < (double)(this.getScrollbarPositionX() + GuiUtil.SCROLLBAR_WIDTH);
    }

    protected double getScrollUnit() {
        return this.autoCalculateScrollUnit ? this.entries.averageItemHeight / 2.0 : this.scrollUnit;
    }

    public int nextTop() {
        return this.top + this.contentPadding + this.entries.nextTop();
    }

    protected static class PositionalLinkedList<E extends Entry<E>>
    implements Iterable<E> {
        private final LinkedList<E> entries = new LinkedList();
        private final int rowPadding;
        private int totalHeight;
        private double averageItemHeight;

        protected PositionalLinkedList(int rowPadding) {
            this.rowPadding = rowPadding;
        }

        public List<E> asList() {
            return List.copyOf(this.entries);
        }

        public void add(E entry) {
            boolean first = this.entries.isEmpty();
            this.entries.add(entry);
            this.totalHeight += ((Entry)((Object)entry)).getHeight() + (first ? 0 : this.rowPadding);
            this.averageItemHeight = (double)this.totalHeight / (double)this.entries.size();
        }

        public E get(int index) {
            return (E)((Object)((Entry)((Object)this.entries.get(index))));
        }

        public int size() {
            return this.entries.size();
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public void clear() {
            this.entries.clear();
            this.totalHeight = 0;
            this.averageItemHeight = 0.0;
        }

        public int nextTop() {
            if (this.entries.isEmpty()) {
                return 0;
            }
            return this.totalHeight + this.rowPadding;
        }

        public E getEntryAtPosition(double y) {
            for (Entry entry : this.entries) {
                if (!(y >= (double)entry.getTop()) || !(y <= (double)entry.getBottom())) continue;
                return (E)((Object)entry);
            }
            return null;
        }

        public int indexOf(E entry) {
            return this.entries.indexOf(entry);
        }

        @Override
        public Iterator<E> iterator() {
            return this.entries.iterator();
        }
    }

    public static abstract class Entry<E extends Entry<E>>
    extends AbstractContainerEventHandler {
        protected static final int ROW_SHADE_STRENGTH = 85;
        protected static final int ROW_SHADE_FADE_WIDTH = 10;
        protected static final int ROW_SHADE_FADE_OVERFLOW = 10;
        protected final Minecraft client;
        protected final VariableHeightListWidget<E> parent;
        private final int left;
        private final int top;
        private final int width;
        private final int height;
        private GuiEventListener focused;
        private NarratableEntry focusedSelectable;

        public Entry(Minecraft client, VariableHeightListWidget<E> parent, int height) {
            this.client = client;
            this.parent = parent;
            this.left = parent.getContentLeft();
            this.width = parent.getContentWidth();
            this.top = parent.nextTop();
            this.height = height;
        }

        public ConfigListWidget getParent() {
            return (ConfigListWidget)this.parent;
        }

        public Minecraft getClient() {
            return this.client;
        }

        public Font getTextRenderer() {
            return this.client.f_91062_;
        }

        public int getTop() {
            return this.top;
        }

        public int getBottom() {
            return this.top + this.height;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.left + this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public void render(GuiGraphics drawContext, int index, double scrollAmount, int mouseX, int mouseY, float delta) {
            this.renderBackground(drawContext, index, scrollAmount, mouseX, mouseY, delta);
            this.renderContent(drawContext, index, scrollAmount, mouseX, mouseY, delta);
            this.renderDecorations(drawContext, index, scrollAmount, mouseX, mouseY, delta);
        }

        public void renderBackground(GuiGraphics drawContext, int index, double scrollAmount, int mouseX, int mouseY, float delta) {
            if (index % 2 == 0) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShader(GameRenderer::m_172811_);
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder bufferBuilder = tessellator.m_85915_();
                Matrix4f matrix4f = drawContext.m_280168_().m_85850_().m_252922_();
                int left = this.left - 10 - this.parent.contentPadding / 2;
                int right = this.left + this.width + 10 + this.parent.contentPadding / 2 + 1;
                int top = this.top - (int)scrollAmount - this.parent.rowPadding / 2;
                int bottom = this.top + this.height - (int)scrollAmount + this.parent.rowPadding / 2 + 1;
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                bufferBuilder.m_252986_(matrix4f, (float)(left + 10), (float)top, 0.0f).m_6122_(0, 0, 0, 85).m_5752_();
                bufferBuilder.m_252986_(matrix4f, (float)left, (float)top, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
                bufferBuilder.m_252986_(matrix4f, (float)left, (float)bottom, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
                bufferBuilder.m_252986_(matrix4f, (float)(left + 10), (float)bottom, 0.0f).m_6122_(0, 0, 0, 85).m_5752_();
                bufferBuilder.m_252986_(matrix4f, (float)(right - 10), (float)top, 0.0f).m_6122_(0, 0, 0, 85).m_5752_();
                bufferBuilder.m_252986_(matrix4f, (float)(left + 10), (float)top, 0.0f).m_6122_(0, 0, 0, 85).m_5752_();
                bufferBuilder.m_252986_(matrix4f, (float)(left + 10), (float)bottom, 0.0f).m_6122_(0, 0, 0, 85).m_5752_();
                bufferBuilder.m_252986_(matrix4f, (float)(right - 10), (float)bottom, 0.0f).m_6122_(0, 0, 0, 85).m_5752_();
                bufferBuilder.m_252986_(matrix4f, (float)right, (float)top, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
                bufferBuilder.m_252986_(matrix4f, (float)(right - 10), (float)top, 0.0f).m_6122_(0, 0, 0, 85).m_5752_();
                bufferBuilder.m_252986_(matrix4f, (float)(right - 10), (float)bottom, 0.0f).m_6122_(0, 0, 0, 85).m_5752_();
                bufferBuilder.m_252986_(matrix4f, (float)right, (float)bottom, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
                tessellator.m_85914_();
                RenderSystem.disableBlend();
            }
        }

        public void renderContent(GuiGraphics drawContext, int index, double scrollAmount, int mouseX, int mouseY, float delta) {
        }

        public void renderDecorations(GuiGraphics drawContext, int index, double scrollAmount, int mouseX, int mouseY, float delta) {
        }

        public List<? extends NarratableEntry> selectableChildren() {
            return this.m_6702_().stream().filter(NarratableEntry.class::isInstance).map(NarratableEntry.class::cast).toList();
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            if (!this.parent.m_5953_(mouseX, mouseY)) {
                return false;
            }
            return mouseX >= (double)this.getLeft() && mouseX <= (double)this.getRight() && mouseY >= (double)this.getTop() && mouseY <= (double)this.getBottom();
        }

        public void m_7522_(GuiEventListener focused) {
            if (this.focused != null) {
                this.focused.m_93692_(false);
            }
            if (focused != null) {
                focused.m_93692_(true);
            }
            this.focused = focused;
        }

        public GuiEventListener m_7222_() {
            return this.focused;
        }

        public ComponentPath getNavigationPath(FocusNavigationEvent navigation, int index) {
            if (this.m_6702_().isEmpty()) {
                return null;
            }
            GuiEventListener child = (GuiEventListener)this.m_6702_().get(Math.min(index, this.m_6702_().size() - 1));
            ComponentPath path = child.m_264064_(navigation);
            return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)path);
        }

        public ComponentPath m_264064_(FocusNavigationEvent navigation) {
            int index;
            int delta;
            if (!(navigation instanceof FocusNavigationEvent.ArrowNavigation)) {
                return super.m_264064_(navigation);
            }
            FocusNavigationEvent.ArrowNavigation arrow = (FocusNavigationEvent.ArrowNavigation)navigation;
            switch (arrow.f_263812_()) {
                case LEFT: {
                    int n = -1;
                    break;
                }
                case RIGHT: {
                    int n = 1;
                    break;
                }
                default: {
                    int n = delta = 0;
                }
            }
            if (delta == 0) {
                return null;
            }
            for (int i = index = Mth.m_14045_((int)(delta + this.m_6702_().indexOf(this.m_7222_())), (int)0, (int)(this.m_6702_().size() - 1)); i >= 0 && i < this.m_6702_().size(); i += delta) {
                ComponentPath path = ((GuiEventListener)this.m_6702_().get(i)).m_264064_(navigation);
                if (path == null) continue;
                return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)path);
            }
            return super.m_264064_(navigation);
        }

        void appendNarrations(NarrationElementOutput builder) {
            List<NarratableEntry> list = this.selectableChildren();
            Screen.NarratableSearchResult data = Screen.m_169400_(list, (NarratableEntry)this.focusedSelectable);
            if (data != null) {
                if (data.f_169422_.m_169123_()) {
                    this.focusedSelectable = data.f_169420_;
                }
                if (list.size() > 1) {
                    builder.m_169146_(NarratedElementType.POSITION, (Component)Component.m_237110_((String)"narrator.position.object_list", (Object[])new Object[]{data.f_169421_ + 1, list.size()}));
                    if (data.f_169422_ == NarratableEntry.NarrationPriority.FOCUSED) {
                        builder.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.component_list.usage"));
                    }
                }
                data.f_169420_.m_142291_(builder.m_142047_());
            }
        }
    }
}

