/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui.widget.config;

import java.util.List;
import java.util.Objects;
import me.roundaround.stackables.roundalib.client.gui.widget.FloatSliderWidget;
import me.roundaround.stackables.roundalib.client.gui.widget.config.ConfigListWidget;
import me.roundaround.stackables.roundalib.client.gui.widget.config.Control;
import me.roundaround.stackables.roundalib.config.option.FloatConfigOption;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class FloatSliderControl
extends Control<Float, FloatConfigOption> {
    private final FloatSliderWidget slider;

    public FloatSliderControl(ConfigListWidget.OptionEntry<Float, FloatConfigOption> parent) {
        super(parent);
        if (!((FloatConfigOption)this.option).useSlider() || ((FloatConfigOption)this.option).getMinValue().isEmpty() || ((FloatConfigOption)this.option).getMaxValue().isEmpty()) {
            throw new IllegalArgumentException("FloatConfigOption must use slider and have min and max values to use FloatSliderControl");
        }
        this.slider = new FloatSliderWidget(this.widgetLeft, this.widgetTop, this.widgetWidth, this.widgetHeight, ((FloatConfigOption)this.option).getMinValue().get().floatValue(), ((FloatConfigOption)this.option).getMaxValue().get().floatValue(), ((FloatConfigOption)this.option).getStep(), ((Float)((FloatConfigOption)this.option).getValue()).floatValue(), this::onSliderChanged, this::getValueAsText);
        this.onDisabledChange(this.disabled, this.disabled);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return List.of(this.slider);
    }

    @Override
    public void setScrollAmount(double scrollAmount) {
        super.setScrollAmount(scrollAmount);
        this.slider.m_253211_(this.scrolledTop);
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.slider.m_88315_(drawContext, mouseX, mouseY, delta);
    }

    @Override
    protected void onConfigValueChange(Float prev, Float curr) {
        if (Objects.equals(curr, Float.valueOf(this.slider.getFloatValue()))) {
            return;
        }
        this.slider.setFloatValue(curr.floatValue());
    }

    @Override
    protected void onDisabledChange(boolean prev, boolean curr) {
        this.slider.f_93623_ = !this.disabled;
    }

    private void onSliderChanged(float value) {
        ((FloatConfigOption)this.option).setValue(Float.valueOf(value));
    }

    private Component getValueAsText(float value) {
        return Component.m_237113_((String)((FloatConfigOption)this.option).getValueAsString(value));
    }
}

