/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui.widget.config;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.List;
import me.roundaround.stackables.roundalib.client.gui.GuiUtil;
import me.roundaround.stackables.roundalib.client.gui.widget.config.ConfigListWidget;
import me.roundaround.stackables.roundalib.client.gui.widget.config.Control;
import me.roundaround.stackables.roundalib.config.option.FloatConfigOption;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;

public class FloatTextControl
extends Control<Float, FloatConfigOption> {
    private static final List<Character> ALLOWED_SPECIAL_CHARS = List.of(Character.valueOf('.'), Character.valueOf(','));
    private final EditBox textField;

    public FloatTextControl(ConfigListWidget.OptionEntry<Float, FloatConfigOption> parent) {
        super(parent);
        this.textField = new EditBox(parent.getTextRenderer(), this.widgetLeft + 1, this.widgetTop + 1, this.widgetWidth - 2, this.widgetHeight - 2, ((FloatConfigOption)this.option).getLabel()){

            public boolean m_5534_(char chr, int keyCode) {
                if (chr == '-' && this.m_94207_() > 0) {
                    return false;
                }
                if (!FloatTextControl.isCharAllowed(chr)) {
                    return false;
                }
                return super.m_5534_(chr, keyCode);
            }
        };
        this.textField.m_94144_(((Float)((FloatConfigOption)this.option).getValue()).toString());
        this.textField.m_94199_(12);
        this.textField.m_94151_(this::onTextChanged);
        this.onDisabledChange(this.disabled, this.disabled);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return List.of(this.textField);
    }

    @Override
    public void setScrollAmount(double scrollAmount) {
        super.setScrollAmount(scrollAmount);
        this.textField.m_253211_(this.scrolledTop + 1);
    }

    @Override
    public void markInvalid() {
        this.textField.m_94202_(GuiUtil.ERROR_COLOR);
        super.markInvalid();
    }

    @Override
    public void markValid() {
        this.textField.m_94202_(GuiUtil.LABEL_COLOR);
        super.markValid();
    }

    @Override
    public void tick() {
        super.tick();
        this.textField.m_94120_();
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.textField.m_88315_(drawContext, mouseX, mouseY, delta);
    }

    @Override
    protected void onConfigValueChange(Float prev, Float curr) {
        try {
            float parsed = this.parseFloat(this.textField.m_94155_());
            if (Math.abs(curr.floatValue() - parsed) < 1.0E-5f) {
                return;
            }
            this.textField.m_94144_(curr.toString());
        }
        catch (Exception e) {
            this.textField.m_94144_(curr.toString());
        }
    }

    @Override
    protected void onDisabledChange(boolean prev, boolean curr) {
        this.textField.f_93623_ = !this.disabled;
        this.textField.m_94186_(!this.disabled);
    }

    private void onTextChanged(String value) {
        try {
            float parsed = this.parseFloat(value);
            if (((FloatConfigOption)this.option).validateInput(parsed)) {
                ((FloatConfigOption)this.option).setValue(Float.valueOf(parsed));
                this.markValid();
            } else {
                this.markInvalid();
            }
        }
        catch (Exception e) {
            this.markInvalid();
        }
    }

    private float parseFloat(String value) throws ParseException {
        DecimalFormat format = new DecimalFormat("#");
        return format.parse(value).floatValue();
    }

    private static boolean isCharAllowed(char chr) {
        return Character.isDigit(chr) || ALLOWED_SPECIAL_CHARS.contains(Character.valueOf(chr));
    }
}

