/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui.widget.config;

import java.util.List;
import java.util.Objects;
import me.roundaround.stackables.roundalib.client.gui.GuiUtil;
import me.roundaround.stackables.roundalib.client.gui.widget.IconButtonWidget;
import me.roundaround.stackables.roundalib.client.gui.widget.config.ConfigListWidget;
import me.roundaround.stackables.roundalib.client.gui.widget.config.Control;
import me.roundaround.stackables.roundalib.client.gui.widget.config.RoundaLibIconButtons;
import me.roundaround.stackables.roundalib.config.option.IntConfigOption;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;

public class IntTextControl
extends Control<Integer, IntConfigOption> {
    private final EditBox textField;
    private final IconButtonWidget plusButton;
    private final IconButtonWidget minusButton;

    public IntTextControl(ConfigListWidget.OptionEntry<Integer, IntConfigOption> parent) {
        super(parent);
        this.textField = new EditBox(parent.getTextRenderer(), this.widgetLeft + 1, this.widgetTop + 1, this.widgetWidth - 2, this.widgetHeight - 2, ((IntConfigOption)this.option).getLabel()){

            public boolean m_5534_(char chr, int keyCode) {
                if (chr == '-' && this.m_94207_() > 0) {
                    return false;
                }
                return super.m_5534_(chr, keyCode);
            }
        };
        this.textField.m_94144_(((Integer)((IntConfigOption)this.option).getValue()).toString());
        this.textField.m_94199_(12);
        this.textField.m_94151_(this::onTextChanged);
        if (((IntConfigOption)this.option).showStepButtons()) {
            this.textField.m_93674_(this.widgetWidth - 9 - 4);
            this.plusButton = RoundaLibIconButtons.intStepButton(this.widgetLeft + this.widgetWidth - 9, this.widgetTop, (IntConfigOption)this.option, true);
            this.minusButton = RoundaLibIconButtons.intStepButton(this.widgetLeft + this.widgetWidth - 9, this.widgetTop + this.widgetHeight - 9, (IntConfigOption)this.option, false);
        } else {
            this.plusButton = null;
            this.minusButton = null;
        }
        this.onDisabledChange(this.disabled, this.disabled);
    }

    public List<? extends GuiEventListener> m_6702_() {
        if (((IntConfigOption)this.option).showStepButtons()) {
            return List.of(this.textField, this.plusButton, this.minusButton);
        }
        return List.of(this.textField);
    }

    @Override
    public void setScrollAmount(double scrollAmount) {
        super.setScrollAmount(scrollAmount);
        this.textField.m_253211_(this.scrolledTop + 1);
        if (((IntConfigOption)this.option).showStepButtons()) {
            this.plusButton.m_253211_(this.scrolledTop);
            this.minusButton.m_253211_(this.scrolledTop + this.widgetHeight - 9);
        }
    }

    @Override
    public void markInvalid() {
        this.textField.m_94202_(GuiUtil.ERROR_COLOR);
        super.markInvalid();
    }

    @Override
    public void markValid() {
        this.textField.m_94202_(GuiUtil.LABEL_COLOR);
        super.markValid();
    }

    @Override
    public void tick() {
        super.tick();
        this.textField.m_94120_();
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.textField.m_88315_(drawContext, mouseX, mouseY, delta);
        if (((IntConfigOption)this.option).showStepButtons()) {
            this.plusButton.m_88315_(drawContext, mouseX, mouseY, delta);
            this.minusButton.m_88315_(drawContext, mouseX, mouseY, delta);
        }
    }

    @Override
    protected void onConfigValueChange(Integer prev, Integer curr) {
        String currStr = String.valueOf(curr);
        if (Objects.equals(currStr, this.textField.m_94155_())) {
            return;
        }
        this.textField.m_94144_(currStr);
    }

    @Override
    protected void onDisabledChange(boolean prev, boolean curr) {
        this.textField.f_93623_ = !this.disabled;
        this.textField.m_94186_(!this.disabled);
    }

    private void onTextChanged(String value) {
        try {
            int parsed = Integer.parseInt(value);
            if (((IntConfigOption)this.option).validateInput(parsed)) {
                ((IntConfigOption)this.option).setValue(parsed);
                this.markValid();
            } else {
                this.markInvalid();
            }
        }
        catch (Exception e) {
            this.markInvalid();
        }
    }
}

