/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.config.option;

import me.roundaround.stackables.roundalib.config.ModConfig;
import me.roundaround.stackables.roundalib.config.option.ConfigOption;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class BooleanConfigOption
extends ConfigOption<Boolean, Builder> {
    private final Component enabledLabel;
    private final Component disabledLabel;

    protected BooleanConfigOption(Builder builder) {
        super(builder);
        this.enabledLabel = builder.enabledLabel;
        this.disabledLabel = builder.disabledLabel;
    }

    protected BooleanConfigOption(BooleanConfigOption other) {
        super(other);
        this.enabledLabel = other.enabledLabel;
        this.disabledLabel = other.disabledLabel;
    }

    public Component getEnabledLabel() {
        return this.enabledLabel;
    }

    public Component getDisabledLabel() {
        return this.disabledLabel;
    }

    public Component getValueLabel() {
        return (Boolean)this.getValue() != false ? this.enabledLabel : this.disabledLabel;
    }

    public boolean toggle() {
        this.setValue((Boolean)this.getValue() == false);
        return (Boolean)this.getValue();
    }

    public BooleanConfigOption copy() {
        return new BooleanConfigOption(this);
    }

    public static Builder builder(ModConfig config, String id, String labelI18nKey) {
        return new Builder(config, id, labelI18nKey);
    }

    public static Builder builder(ModConfig config, String id, Component label) {
        return new Builder(config, id, label);
    }

    public static Builder onOffBuilder(ModConfig config, String id, String labelI18nKey) {
        return new Builder(config, id, labelI18nKey).setEnabledLabel(CommonComponents.f_130653_).setDisabledLabel(CommonComponents.f_130654_);
    }

    public static Builder onOffBuilder(ModConfig config, String id, Component label) {
        return new Builder(config, id, label).setEnabledLabel(CommonComponents.f_130653_).setDisabledLabel(CommonComponents.f_130654_);
    }

    public static Builder yesNoBuilder(ModConfig config, String id, String labelI18nKey) {
        return new Builder(config, id, labelI18nKey).setEnabledLabel(CommonComponents.f_130657_).setDisabledLabel(CommonComponents.f_130658_);
    }

    public static Builder yesNoBuilder(ModConfig config, String id, Component label) {
        return new Builder(config, id, label).setEnabledLabel(CommonComponents.f_130657_).setDisabledLabel(CommonComponents.f_130658_);
    }

    public static class Builder
    extends ConfigOption.AbstractBuilder<Boolean, Builder> {
        private Component enabledLabel;
        private Component disabledLabel;

        private Builder(ModConfig config, String id, String labelI18nKey) {
            super(config, id, labelI18nKey, Boolean.valueOf(true));
            this.enabledLabel = Component.m_237115_((String)(this.config.getModId() + ".roundalib.toggle.enabled"));
            this.disabledLabel = Component.m_237115_((String)(this.config.getModId() + ".roundalib.toggle.disabled"));
        }

        private Builder(ModConfig config, String id, Component label) {
            super(config, id, label, Boolean.valueOf(true));
            this.enabledLabel = Component.m_237115_((String)(this.config.getModId() + ".roundalib.toggle.enabled"));
            this.disabledLabel = Component.m_237115_((String)(this.config.getModId() + ".roundalib.toggle.disabled"));
        }

        public Builder setDefaultValue(Boolean defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setEnabledLabel(String i18nKey) {
            this.enabledLabel = Component.m_237115_((String)i18nKey);
            return this;
        }

        public Builder setEnabledLabel(Component label) {
            this.enabledLabel = label;
            return this;
        }

        public Builder setDisabledLabel(String i18nKey) {
            this.disabledLabel = Component.m_237115_((String)i18nKey);
            return this;
        }

        public Builder setDisabledLabel(Component label) {
            this.disabledLabel = label;
            return this;
        }

        public BooleanConfigOption build() {
            return new BooleanConfigOption(this);
        }
    }
}

