/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.config.value;

import java.util.Arrays;
import me.roundaround.stackables.roundalib.config.ModConfig;
import me.roundaround.stackables.roundalib.config.value.ListOptionValue;
import net.minecraft.world.level.GameType;

public enum GameMode implements ListOptionValue<GameMode>
{
    SURVIVAL(GameType.SURVIVAL),
    CREATIVE(GameType.CREATIVE),
    ADVENTURE(GameType.ADVENTURE),
    SPECTATOR(GameType.SPECTATOR);

    private final String id;
    private final GameType vanillaGameMode;

    private GameMode(GameType vanillaGameMode) {
        this.id = vanillaGameMode.m_46405_();
        this.vanillaGameMode = vanillaGameMode;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getI18nKey(ModConfig config) {
        return "selectWorld.gameMode." + this.id;
    }

    @Override
    public GameMode getFromId(String id) {
        return Arrays.stream(GameMode.values()).filter(gamemode -> gamemode.id.equals(id)).findFirst().orElse(GameMode.getDefault());
    }

    @Override
    public GameMode getNext() {
        return GameMode.values()[(this.ordinal() + 1) % GameMode.values().length];
    }

    @Override
    public GameMode getPrev() {
        return GameMode.values()[(this.ordinal() + GameMode.values().length - 1) % GameMode.values().length];
    }

    public GameType getVanillaGameMode() {
        return this.vanillaGameMode;
    }

    public static GameMode getDefault() {
        return SURVIVAL;
    }
}

