/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.mojang.blaze3d.platform.NativeImage;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.texture.TextureErrorException;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import com.supermartijn642.fusion.texture.FusionTextureMetadataSection;
import com.supermartijn642.fusion.texture.SpriteCreationContextImpl;
import com.supermartijn642.fusion.texture.SpritePreparationContextImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SpriteLoader.class}, priority=900)
public class SpriteLoaderMixin {
    @Final
    @Shadow
    private static Logger f_244357_;
    @Unique
    private static final Map<ResourceLocation, Pair<TextureType<Object>, Object>> fusionTextureMetadata;

    @Inject(method={"loadSprite"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/resources/metadata/animation/AnimationMetadataSection;calculateFrameSize(II)Lnet/minecraft/client/resources/metadata/animation/FrameSize;", shift=At.Shift.AFTER)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void gatherMetadata(ResourceLocation identifier, Resource resource, CallbackInfoReturnable<SpriteContents> ci, AnimationMetadataSection animationMetadata, NativeImage image, FrameSize originalSize) {
        Pair metadata = null;
        try {
            metadata = resource.m_215509_().m_214059_((MetadataSectionSerializer)FusionTextureMetadataSection.INSTANCE).orElse(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (metadata != null) {
            Pair<Integer, Integer> newSize;
            fusionTextureMetadata.put(identifier, metadata);
            try {
                newSize = ((TextureType)metadata.left()).getFrameSize(new SpritePreparationContextImpl(originalSize.f_244129_(), originalSize.f_244503_(), image.m_84982_(), image.m_85084_(), identifier, animationMetadata), metadata.right());
            }
            catch (TextureErrorException e) {
                FusionClient.LOGGER.error("Error for texture '{}': {}", (Object)identifier, (Object)e.getMessage());
                image.close();
                ci.setReturnValue(null);
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst getting frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left()) + "' for texture '" + identifier + "'!", e);
            }
            if (newSize == null) {
                throw new RuntimeException("Received null frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left()) + "' for texture '" + identifier + "'!");
            }
            ci.setReturnValue((Object)new SpriteContents(identifier, new FrameSize(newSize.left().intValue(), newSize.right().intValue()), image, animationMetadata));
        }
    }

    @Inject(method={"loadAndStitch"}, at={@At(value="RETURN")})
    private void initializeTextures(ResourceManager resourceManager, ResourceLocation atlas, int i, Executor executor, CallbackInfoReturnable<CompletableFuture<SpriteLoader.Preparations>> ci) {
        ((CompletableFuture)ci.getReturnValue()).thenApply(preparations -> {
            Map textures = preparations.f_243807_();
            for (Map.Entry<ResourceLocation, Pair<TextureType<Object>, Object>> entry : fusionTextureMetadata.entrySet()) {
                TextureAtlasSprite newTexture;
                ResourceLocation identifier = entry.getKey();
                TextureAtlasSprite texture = (TextureAtlasSprite)textures.get(identifier);
                Pair<TextureType<Object>, Object> textureData = entry.getValue();
                if (texture == null) continue;
                try (SpriteCreationContextImpl context = new SpriteCreationContextImpl((SpriteLoader.Preparations)preparations, atlas, texture);){
                    newTexture = textureData.left().createSprite(context, textureData.right());
                }
                catch (Exception e) {
                    throw new RuntimeException("Encountered an exception whilst initialising texture '" + identifier + "' for texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "'!", e);
                }
                if (newTexture == null) {
                    throw new RuntimeException("Received null texture from texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "' for texture '" + identifier + "'!");
                }
                ((TextureAtlasSpriteExtension)newTexture).setFusionTextureType(textureData.left());
                textures.put(identifier, newTexture);
            }
            fusionTextureMetadata.clear();
            return preparations;
        });
    }

    static {
        fusionTextureMetadata = new ConcurrentHashMap<ResourceLocation, Pair<TextureType<Object>, Object>>();
    }
}

