/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.content.ContentListing;
import slimeknights.mantle.client.book.transformer.IndexTransformer;
import slimeknights.mantle.client.screen.book.element.BookElement;

public class ContentIndex
extends ContentListing {
    public static final transient ResourceLocation ID = Mantle.getResource("index");
    private transient boolean loaded = false;
    private String[] hidden;
    private Operation[] operations;

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        if (!this.loaded) {
            this.loaded = true;
            Set hiddenSet = this.hidden == null ? Set.of() : Set.of(this.hidden);
            Operation[] operations = Objects.requireNonNullElse(this.operations, new Operation[0]);
            this.parent.parent.pages.forEach(page -> {
                if (!(page == this.parent || IndexTransformer.isPageHidden(page) || "hidden".equals(page.name) || hiddenSet.contains(page.name))) {
                    block10: for (Operation operation : operations) {
                        if (!page.name.equals(operation.before)) continue;
                        switch (operation.action) {
                            case "add_group": {
                                this.addEntry(operation.data, null, true);
                                continue block10;
                            }
                            case "column_break": {
                                this.addColumnBreak();
                                continue block10;
                            }
                            case "line_break": {
                                this.addEntry("", null, false);
                                continue block10;
                            }
                            default: {
                                Mantle.logger.error("Unknown ContentIndex action " + operation.action);
                            }
                        }
                    }
                    this.addEntry(page.getTitle(), (PageData)page, page.name.startsWith("group_"));
                }
            });
        }
        super.build(book, list, rightSide);
    }

    protected static final class Operation {
        private final String before;
        private final String action;
        private final String data;

        public Operation(String before, String action, String data) {
            this.before = before;
            this.action = action;
            this.data = data;
        }
    }
}

