/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import slimeknights.mantle.client.render.FaucetFluid;
import slimeknights.mantle.client.render.FluidCuboid;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.mantle.client.render.RenderItem;

public class RenderingHelper {
    public static boolean applyRotation(PoseStack matrices, BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            return RenderingHelper.applyRotation(matrices, (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_));
        }
        return false;
    }

    public static boolean applyRotation(PoseStack matrices, Direction facing) {
        if (facing.m_122434_().m_122479_() && facing != Direction.SOUTH) {
            matrices.m_85836_();
            matrices.m_85837_(0.5, 0.0, 0.5);
            matrices.m_252781_(Axis.f_252436_.m_252977_(-90.0f * (float)facing.m_122416_()));
            matrices.m_85837_(-0.5, 0.0, -0.5);
            return true;
        }
        return false;
    }

    public static void renderItem(PoseStack matrices, MultiBufferSource buffer, ItemStack item, RenderItem renderItem, int light) {
        float y;
        if (renderItem.isHidden()) {
            return;
        }
        if (item.m_41619_()) {
            return;
        }
        matrices.m_85836_();
        Vector3f center = renderItem.getCenterScaled();
        matrices.m_252880_(center.x(), center.y(), center.z());
        float scale = renderItem.getSizeScaled();
        matrices.m_85841_(scale, scale, scale);
        float x = renderItem.getX();
        if (x != 0.0f) {
            matrices.m_252781_(Axis.f_252529_.m_252977_(x));
        }
        if ((y = (float)renderItem.getY()) != 0.0f) {
            matrices.m_252781_(Axis.f_252436_.m_252977_(y));
        }
        Minecraft.m_91087_().m_91291_().m_269128_(item, renderItem.getTransform(), light, OverlayTexture.f_118083_, matrices, buffer, (Level)Minecraft.m_91087_().f_91073_, 0);
        matrices.m_85849_();
    }

    public static void renderFaucetFluids(LevelAccessor world, BlockPos pos, Direction direction, PoseStack matrices, VertexConsumer buffer, TextureAtlasSprite still, TextureAtlasSprite flowing, int color, int light) {
        FaucetFluid faucetFluid;
        int i = 0;
        do {
            faucetFluid = FaucetFluid.REGISTRY.get(world.m_8055_(pos.m_6625_(++i)));
            matrices.m_85836_();
            matrices.m_252880_(0.0f, (float)(-i), 0.0f);
            for (FluidCuboid cube : faucetFluid.getFluids(direction)) {
                FluidRenderer.renderCuboid(matrices, buffer, cube, still, flowing, cube.getFromScaled(), cube.getToScaled(), color, light, false);
            }
            matrices.m_85849_();
        } while (faucetFluid.isContinued());
    }
}

