/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.plugin.jei.entity;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;

public class EntityIngredientRenderer
implements IIngredientRenderer<EntityIngredient.EntityInput> {
    private static final ResourceLocation MISSING = Mantle.getResource("textures/item/missingno.png");
    private static final Set<EntityType<?>> IGNORED_ENTITIES = new HashSet();
    private final int size;
    private final Map<EntityType<?>, Entity> ENTITY_MAP = new HashMap();

    public int getWidth() {
        return this.size;
    }

    public int getHeight() {
        return this.size;
    }

    public void render(GuiGraphics graphics, @Nullable EntityIngredient.EntityInput input) {
        if (input != null) {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            EntityType<?> type = input.type();
            if (world != null && !IGNORED_ENTITIES.contains(type)) {
                Object entity = type == EntityType.f_20532_ ? Minecraft.m_91087_().f_91074_ : this.ENTITY_MAP.computeIfAbsent(type, arg_0 -> EntityIngredientRenderer.lambda$render$0((Level)world, arg_0));
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    int scale = this.size / 2;
                    float height = entity.m_20206_();
                    float width = entity.m_20205_();
                    if (height > 2.0f || width > 2.0f) {
                        scale = (int)((float)this.size / Math.max(height, width));
                    }
                    try {
                        InventoryScreen.m_274545_((GuiGraphics)graphics, (int)(this.size / 2), (int)this.size, (int)scale, (float)0.0f, (float)10.0f, (LivingEntity)livingEntity);
                        return;
                    }
                    catch (Exception e) {
                        Mantle.logger.error("Error drawing entity " + BuiltInRegistries.f_256780_.m_7981_(type), (Throwable)e);
                        IGNORED_ENTITIES.add(type);
                        this.ENTITY_MAP.remove(type);
                    }
                } else {
                    IGNORED_ENTITIES.add(type);
                    this.ENTITY_MAP.remove(type);
                }
            }
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int offset = (this.size - 16) / 2;
            graphics.m_280163_(MISSING, offset, offset, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    public List<Component> getTooltip(EntityIngredient.EntityInput type, TooltipFlag flag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(type.type().m_20676_());
        if (flag.m_7050_()) {
            tooltip.add((Component)Component.m_237113_((String)BuiltInRegistries.f_256780_.m_7981_(type.type()).toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    public EntityIngredientRenderer(int size) {
        this.size = size;
    }

    private static /* synthetic */ Entity lambda$render$0(Level world, EntityType t) {
        return t.m_20615_(world);
    }
}

