/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge;

import dev.architectury.registry.registries.RegistrarManager;
import hardcorequesting.common.forge.client.sounds.Sounds;
import hardcorequesting.common.forge.commands.CommandHandler;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.event.PlayerDeathEventListener;
import hardcorequesting.common.forge.event.PlayerTracker;
import hardcorequesting.common.forge.event.WorldEventListener;
import hardcorequesting.common.forge.io.FileDataManager;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.platform.AbstractPlatform;
import hardcorequesting.common.forge.proxies.ClientProxy;
import hardcorequesting.common.forge.proxies.CommonProxy;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.util.Executor;
import hardcorequesting.common.forge.util.RegisterHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HardcoreQuestingCore {
    public static final String ID = "hardcorequesting";
    public static CommonProxy proxy;
    public static Path configDir;
    public static Path packDir;
    public static FileDataManager packManager;
    public static final Logger LOGGER;
    public static AbstractPlatform platform;

    public static MinecraftServer getServer() {
        return platform == null ? null : platform.getServer();
    }

    public static void initialize(AbstractPlatform platform) {
        HardcoreQuestingCore.platform = platform;
        proxy = (CommonProxy)Executor.call(() -> ClientProxy::new, () -> CommonProxy::new);
        new EventTrigger();
        configDir = platform.getConfigDir().resolve("hqm");
        packDir = configDir.resolve("default");
        packManager = new FileDataManager(packDir);
        try {
            FileUtils.deleteDirectory((File)configDir.resolve("remote").toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        QuestLine.reset();
        HQMConfig.loadConfig();
        proxy.init();
        new PlayerDeathEventListener();
        new PlayerTracker();
        NetworkManager.init();
        RegisterHelper.register();
        Sounds.registerSounds();
        platform.registerOnCommandRegistration(CommandHandler::register);
        platform.registerOnWorldLoad(WorldEventListener::onLoad);
        platform.registerOnWorldSave(WorldEventListener::onSave);
        platform.registerOnPlayerJoin(playerEntity -> {
            PlayerTracker.instance.onPlayerLogin((ServerPlayer)playerEntity);
            EventTrigger.instance().onPlayerLogin((ServerPlayer)playerEntity);
        });
        platform.registerOnLivingDeath((livingEntity, source) -> {
            PlayerDeathEventListener.instance.onLivingDeath((LivingEntity)livingEntity, (DamageSource)source);
            EventTrigger.instance().onLivingDeath((LivingEntity)livingEntity, (DamageSource)source);
        });
        RegistrarManager registries = RegistrarManager.get((String)ID);
        registries.builder(TaskType.REGISTRY_KEY.m_135782_(), (Object[])new TaskType[0]).syncToClients().build();
        TaskType.REGISTER.register();
    }

    static {
        LOGGER = LogManager.getFormatterLogger((String)"Hardcore Questing Mode");
    }
}

