/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.bag;

import hardcorequesting.common.forge.bag.BagTier;
import hardcorequesting.common.forge.bag.TierColor;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.util.Translator;
import hardcorequesting.common.forge.util.WrappedText;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GroupTier {
    private WrappedText name;
    private TierColor color;
    private int[] weights;

    public GroupTier(String name, TierColor color, int ... weights) {
        this(WrappedText.create(name), color, weights);
    }

    public GroupTier(WrappedText name, TierColor color, int ... weights) {
        this.name = name;
        this.color = color;
        this.weights = Arrays.copyOf(weights, BagTier.values().length);
    }

    public static void initBaseTiers(QuestLine questLine) {
        List<GroupTier> tiers = questLine.groupTierManager.getTiers();
        tiers.add(new GroupTier("Crap", TierColor.RED, 50, 50, 50, 5, 0));
        tiers.add(new GroupTier("Plain", TierColor.GRAY, 50, 50, 50, 30, 10));
        tiers.add(new GroupTier("Common", TierColor.GREEN, 20, 30, 40, 30, 20));
        tiers.add(new GroupTier("Uncommon", TierColor.BLUE, 5, 10, 15, 20, 25));
        tiers.add(new GroupTier("Rare", TierColor.ORANGE, 3, 6, 12, 18, 21));
        tiers.add(new GroupTier("Unique", TierColor.PURPLE, 1, 2, 3, 4, 30));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getName() {
        return this.name == null || this.name.getRawText().isEmpty() ? Translator.translatable("hqm.bag.unknown", new Object[0]) : this.name.getText();
    }

    public void setName(WrappedText name) {
        this.name = name;
    }

    public WrappedText getRawName() {
        return this.name;
    }

    public TierColor getColor() {
        return this.color;
    }

    public void setColor(TierColor color) {
        this.color = color;
    }

    public int[] getWeights() {
        return this.weights;
    }

    public GroupTier copy() {
        return new GroupTier(this.name, this.getColor(), this.getWeights());
    }

    public void load(GroupTier tier) {
        this.name = tier.name;
        this.color = tier.color;
        this.weights = Arrays.copyOf(tier.weights, BagTier.values().length);
    }
}

