/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.bag;

import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import hardcorequesting.common.forge.bag.GroupTier;
import hardcorequesting.common.forge.bag.LootGroup;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.SimpleSerializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class GroupTierManager
extends SimpleSerializable {
    public static final String FILE_PATH = "bags.json";
    public final Map<UUID, LootGroup> groups = new ConcurrentHashMap<UUID, LootGroup>();
    private final List<GroupTier> tiers = Lists.newArrayList();

    public static GroupTierManager getInstance() {
        return QuestLine.getActiveQuestLine().groupTierManager;
    }

    @Override
    public String saveToString() {
        return SaveHandler.save(this.tiers, new TypeToken<List<GroupTier>>(){}.getType());
    }

    @Override
    public void clear() {
        this.groups.clear();
        this.tiers.clear();
    }

    @Override
    public void loadFromString(String string) {
        SaveHandler.load(string, new TypeToken<List<GroupTier>>(){}.getType()).ifPresent(this.tiers::addAll);
    }

    @Override
    public String filePath() {
        return FILE_PATH;
    }

    @Override
    public boolean isData() {
        return false;
    }

    public List<GroupTier> getTiers() {
        return this.tiers;
    }
}

