/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.bag;

import hardcorequesting.common.forge.bag.GroupData;
import hardcorequesting.common.forge.bag.GroupTier;
import hardcorequesting.common.forge.bag.GroupTierManager;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.reward.QuestRewards;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import hardcorequesting.common.forge.util.WrappedText;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootGroup {
    private GroupTier tier;
    private final NonNullList<ItemStack> items;
    @Nullable
    private WrappedText name;
    private int limit;
    private UUID groupId;

    public LootGroup(UUID groupId) {
        this.groupId = groupId;
        while (this.groupId == null || LootGroup.getGroups().containsKey(this.groupId)) {
            this.groupId = UUID.randomUUID();
        }
        if (groupId == null) {
            if (GroupTierManager.getInstance().getTiers().size() < 1) {
                GroupTier.initBaseTiers(QuestLine.getActiveQuestLine());
            }
            this.tier = GroupTierManager.getInstance().getTiers().get(0);
        }
        this.items = NonNullList.m_122779_();
    }

    public static int size() {
        return GroupTierManager.getInstance().groups.size();
    }

    public static Map<UUID, LootGroup> getGroups() {
        return GroupTierManager.getInstance().groups;
    }

    public static void remove(UUID groupId) {
        LootGroup.getGroups().remove(groupId);
    }

    public static void add(LootGroup group) {
        LootGroup.getGroups().put(group.getId(), group);
    }

    public static LootGroup getGroup(UUID groupId) {
        return LootGroup.getGroups().get(groupId);
    }

    public GroupTier getTier() {
        return this.tier;
    }

    public void setTier(GroupTier tier) {
        this.tier = tier;
    }

    public FormattedText getDisplayName() {
        return this.name != null ? this.name.getText() : this.getDefaultName();
    }

    @NotNull
    public WrappedText getRawName() {
        return this.name != null ? this.name : WrappedText.create(this.getDefaultName().getString());
    }

    private Component getDefaultName() {
        return Translator.translatable("hqm.bag.group", this.tier.getName());
    }

    public void setName(@Nullable WrappedText name) {
        this.name = name;
        SaveHelper.add(EditType.NAME_CHANGE);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItem(int id, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        if (id >= this.items.size()) {
            this.items.add((Object)stack);
            SaveHelper.add(EditType.GROUP_ITEM_CREATE);
        } else {
            this.items.set(id, (Object)stack);
            SaveHelper.add(EditType.GROUP_ITEM_CHANGE);
        }
    }

    public void open(Player player) {
        GroupData data;
        if (this.limit > 0 && (data = QuestingDataManager.getInstance().getQuestingData(player).getGroupData(this.getId())) != null) {
            ++data.retrieved;
        }
        List<ItemStack> itemsToAdd = this.items.stream().map(ItemStack::m_41777_).collect(Collectors.toList());
        QuestRewards.addItems(player, itemsToAdd);
        itemsToAdd.stream().filter(item -> item.m_41613_() > 0).forEach(item -> {
            ItemEntity entityItem = new ItemEntity(player.m_20193_(), player.m_20185_() + 0.5, player.m_20186_() + 0.5, player.m_20189_() + 0.5, item);
            player.m_20193_().m_7967_((Entity)entityItem);
        });
    }

    public UUID getId() {
        return this.groupId;
    }

    public void removeItem(int i) {
        if (i >= 0 && i < this.items.size()) {
            this.items.remove(i);
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getRetrievalCount(Player player) {
        GroupData data = QuestingDataManager.getInstance().getQuestingData(player).getGroupData(this.getId());
        return data != null ? data.retrieved : 0;
    }

    public void setRetrievalCount(Player player, int count) {
        GroupData data = QuestingDataManager.getInstance().getQuestingData(player).getGroupData(this.getId());
        if (data != null) {
            data.retrieved = count;
        }
    }

    public boolean isValid(Player player) {
        return this.limit == 0 || this.getRetrievalCount(player) < this.limit;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LootGroup && Objects.equals(this.name, ((LootGroup)obj).name) && this.limit == ((LootGroup)obj).limit && this.items.size() == ((LootGroup)obj).items.size()) {
            for (ItemStack stack : this.items) {
                if (this.listContains(stack, (List<ItemStack>)((LootGroup)obj).items)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean listContains(ItemStack stack, List<ItemStack> stacks) {
        for (ItemStack stack2 : stacks) {
            if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)stack2)) continue;
            return true;
        }
        return false;
    }
}

