/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client;

import hardcorequesting.common.forge.bag.LootGroup;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.graphic.DeathStatsGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.EditBagsGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.EditGroupGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.EditReputationGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.Graphic;
import hardcorequesting.common.forge.client.interfaces.graphic.MainPageGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.MenuPageGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.QuestGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.QuestSetMapGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.QuestSetsGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.TeamListGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.TeamMenuGraphic;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class BookPage {
    private final BookPage parent;

    private BookPage(BookPage parent) {
        this.parent = parent;
    }

    public abstract Graphic createGraphic(GuiQuestBook var1);

    @NotNull
    public final BookPage getParent() {
        return Objects.requireNonNull(this.parent, "This page does not have a parent!");
    }

    public boolean canGoBack() {
        return this.parent != null;
    }

    public boolean hasGoToMenuButton() {
        return true;
    }

    public static class DeathInfoPage
    extends BookPage {
        public static final DeathInfoPage INSTANCE = new DeathInfoPage();

        private DeathInfoPage() {
            super(MenuPage.INSTANCE);
        }

        @Override
        public Graphic createGraphic(GuiQuestBook gui) {
            return new DeathStatsGraphic(gui);
        }
    }

    public static class TeamListPage
    extends BookPage {
        public static final TeamListPage INSTANCE = new TeamListPage();

        private TeamListPage() {
            super(TeamPage.INSTANCE);
        }

        @Override
        public Graphic createGraphic(GuiQuestBook gui) {
            return new TeamListGraphic(gui);
        }
    }

    public static class TeamPage
    extends BookPage {
        public static final TeamPage INSTANCE = new TeamPage();

        private TeamPage() {
            super(MenuPage.INSTANCE);
        }

        @Override
        public Graphic createGraphic(GuiQuestBook gui) {
            return new TeamMenuGraphic(gui, gui.getPlayer().m_20148_());
        }
    }

    public static class GroupPage
    extends BookPage {
        private final LootGroup group;

        private GroupPage(BagsPage parent, LootGroup group) {
            super(parent);
            this.group = group;
        }

        @Override
        public Graphic createGraphic(GuiQuestBook gui) {
            return new EditGroupGraphic(gui, this.group);
        }
    }

    public static class BagsPage
    extends BookPage {
        public static final BagsPage INSTANCE = new BagsPage();

        private BagsPage() {
            super(MenuPage.INSTANCE);
        }

        @Override
        public Graphic createGraphic(GuiQuestBook gui) {
            return new EditBagsGraphic(this, gui);
        }

        public BookPage forGroup(LootGroup group) {
            return new GroupPage(this, group);
        }
    }

    public static class ReputationPage
    extends BookPage {
        public static final ReputationPage INSTANCE = new ReputationPage();

        private ReputationPage() {
            super(MenuPage.INSTANCE);
        }

        @Override
        public Graphic createGraphic(GuiQuestBook gui) {
            return new EditReputationGraphic(gui);
        }
    }

    public static class QuestPage
    extends BookPage {
        private final Quest quest;

        private QuestPage(SetMapPage parent, Quest quest) {
            super(parent);
            this.quest = quest;
        }

        @Override
        public Graphic createGraphic(GuiQuestBook gui) {
            return new QuestGraphic(gui.getPlayer().m_20148_(), this.quest, gui);
        }
    }

    public static class SetMapPage
    extends BookPage {
        private final QuestSet set;

        private SetMapPage(SetsPage parent, QuestSet set) {
            super(parent);
            this.set = Objects.requireNonNull(set);
        }

        @Override
        public Graphic createGraphic(GuiQuestBook gui) {
            return new QuestSetMapGraphic(gui, this.set, this);
        }

        public BookPage forQuest(Quest quest) {
            return new QuestPage(this, quest);
        }
    }

    public static class SetsPage
    extends BookPage {
        public static final SetsPage INSTANCE = new SetsPage();

        private SetsPage() {
            super(MenuPage.INSTANCE);
        }

        @Override
        public Graphic createGraphic(GuiQuestBook gui) {
            return new QuestSetsGraphic(this, gui);
        }

        public BookPage forSet(QuestSet set) {
            return new SetMapPage(this, set);
        }
    }

    public static class MenuPage
    extends BookPage {
        public static final MenuPage INSTANCE = new MenuPage();

        private MenuPage() {
            super(MainPage.INSTANCE);
        }

        @Override
        public Graphic createGraphic(GuiQuestBook gui) {
            return new MenuPageGraphic(gui);
        }

        @Override
        public boolean hasGoToMenuButton() {
            return false;
        }
    }

    public static class MainPage
    extends BookPage {
        public static final MainPage INSTANCE = new MainPage();

        private MainPage() {
            super(null);
        }

        @Override
        public Graphic createGraphic(GuiQuestBook gui) {
            return new MainPageGraphic(gui);
        }

        @Override
        public boolean hasGoToMenuButton() {
            return false;
        }
    }
}

