/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.common.forge.client.sounds.SoundHandler;
import hardcorequesting.common.forge.client.sounds.Sounds;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.message.ClientUpdateMessage;
import hardcorequesting.common.forge.network.message.SoundMessage;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.task.CheckBoxTask;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.tileentity.TrackerBlockEntity;
import hardcorequesting.common.forge.tileentity.TrackerType;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;

public enum ClientChange {
    SELECT_QUEST(new ClientUpdater<QuestTask>(){
        private static final String PARENT = "parent";
        private static final String TASK = "task";

        @Override
        public IMessage build(QuestTask data) throws IOException {
            StringWriter sWriter = new StringWriter();
            JsonWriter writer = new JsonWriter((Writer)sWriter);
            writer.beginObject();
            writer.name(PARENT).value(data.getParent().getQuestId().toString());
            writer.name(TASK).value((long)data.getId());
            writer.endObject();
            writer.close();
            return new ClientUpdateMessage(SELECT_QUEST, sWriter.toString());
        }

        @Override
        public void parse(Player player, String data) {
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(data).getAsJsonObject();
            QuestingDataManager.getInstance().getQuestingData((Player)player).selectedQuestId = UUID.fromString(root.get(PARENT).getAsString());
            QuestingDataManager.getInstance().getQuestingData((Player)player).selectedTask = root.get(TASK).getAsInt();
        }
    }),
    UPDATE_TASK(new ClientUpdater<QuestTask>(){
        private static final String QUEST = "quest";
        private static final String TASK = "task";

        @Override
        public IMessage build(QuestTask questTask) throws IOException {
            StringWriter sWriter = new StringWriter();
            JsonWriter writer = new JsonWriter((Writer)sWriter);
            writer.beginObject();
            writer.name(QUEST).value(questTask.getParent().getQuestId().toString());
            writer.name(TASK).value((long)questTask.getId());
            writer.endObject();
            writer.close();
            return new ClientUpdateMessage(UPDATE_TASK, sWriter.toString());
        }

        @Override
        public void parse(Player player, String data) {
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(data).getAsJsonObject();
            Quest quest = Quest.getQuest(UUID.fromString(root.get(QUEST).getAsString()));
            int task = root.get(TASK).getAsInt();
            if (quest != null && task > -1 && task < quest.getTasks().size()) {
                quest.getTasks().get(task).onUpdate(player);
            }
        }
    }),
    CLAIM_QUEST(new ClientUpdater<Tuple<UUID, Integer>>(){
        private static final String QUEST = "quest";
        private static final String REWARD = "reward";

        @Override
        public IMessage build(Tuple<UUID, Integer> data) throws IOException {
            StringWriter sWriter = new StringWriter();
            JsonWriter writer = new JsonWriter((Writer)sWriter);
            writer.beginObject();
            writer.name(QUEST).value(((UUID)data.m_14418_()).toString());
            writer.name(REWARD).value((Number)data.m_14419_());
            writer.endObject();
            writer.close();
            return new ClientUpdateMessage(CLAIM_QUEST, sWriter.toString());
        }

        @Override
        public void parse(Player player, String data) {
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(data).getAsJsonObject();
            Quest quest = Quest.getQuest(UUID.fromString(root.get(QUEST).getAsString()));
            if (quest != null) {
                quest.getRewards().claimReward(player, root.get(REWARD).getAsInt());
            }
        }
    }),
    TRACKER_UPDATE(new ClientUpdater<TrackerBlockEntity>(){
        private static final String BLOCK_POS = "blockPos";
        private static final String RADIUS = "radius";
        private static final String TYPE = "trackerType";

        @Override
        public IMessage build(TrackerBlockEntity data) throws IOException {
            StringWriter sWriter = new StringWriter();
            JsonWriter writer = new JsonWriter((Writer)sWriter);
            writer.beginObject();
            writer.name(BLOCK_POS).value(data.m_58899_().m_121878_());
            writer.name(RADIUS).value((long)data.getRadius());
            writer.name(TYPE).value((long)data.getTrackerType().ordinal());
            writer.endObject();
            return new ClientUpdateMessage(TRACKER_UPDATE, sWriter.toString());
        }

        @Override
        public void parse(Player player, String data) {
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(data).getAsJsonObject();
            BlockPos pos = BlockPos.m_122022_((long)root.get(BLOCK_POS).getAsLong());
            int radius = root.get(RADIUS).getAsInt();
            TrackerType type = TrackerType.values()[root.get(TYPE).getAsInt()];
            TrackerBlockEntity.saveToServer(player, pos, radius, type);
        }
    }),
    SOUND(new ClientUpdater<Sounds>(){

        @Override
        public IMessage build(Sounds data) throws IOException {
            return new SoundMessage(SOUND, "" + data.ordinal());
        }

        @Override
        public void parse(Player player, String data) {
            SoundHandler.handleSoundPacket(Sounds.values()[Integer.parseInt(data)]);
        }
    }),
    LORE(new ClientUpdater(){

        public IMessage build(Object data) throws IOException {
            return new SoundMessage(LORE, "nothing");
        }

        @Override
        public void parse(Player player, String data) {
            SoundHandler.handleLorePacket(player);
        }
    }),
    COMPLETE_CHECKBOX_TASK(new ClientUpdater<CheckBoxTask>(){
        private static final String QUEST = "quest";
        private static final String TASK = "task";

        @Override
        public IMessage build(CheckBoxTask questTask) throws IOException {
            StringWriter sWriter = new StringWriter();
            JsonWriter writer = new JsonWriter((Writer)sWriter);
            writer.beginObject();
            writer.name(QUEST).value(questTask.getParent().getQuestId().toString());
            writer.name(TASK).value((long)questTask.getId());
            writer.endObject();
            writer.close();
            return new ClientUpdateMessage(COMPLETE_CHECKBOX_TASK, sWriter.toString());
        }

        @Override
        public void parse(Player player, String data) {
            QuestTask<?> taskObj;
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(data).getAsJsonObject();
            Quest quest = Quest.getQuest(UUID.fromString(root.get(QUEST).getAsString()));
            int task = root.get(TASK).getAsInt();
            if (quest != null && task > -1 && task < quest.getTasks().size() && (taskObj = quest.getTasks().get(task)).getType() == TaskType.CHECKBOX.get()) {
                taskObj.completeTask(player.m_20148_());
                quest.sendUpdatedDataToTeam(player);
            }
        }
    });

    private ClientUpdater updater;

    private ClientChange(ClientUpdater updater) {
        this.updater = updater;
    }

    public void parse(Player player, String data) {
        this.updater.parse(player, data);
    }

    public IMessage build(Object data) {
        try {
            return this.updater.build(data);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static interface ClientUpdater<T> {
        public IMessage build(T var1) throws IOException;

        public void parse(Player var1, String var2);
    }
}

