/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client;

import com.mojang.blaze3d.platform.InputConstants;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.KeyboardHandler;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.util.Translator;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.ComponentCollector;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class EditButton {
    private static final int BUTTON_SIZE = 16;
    private static final int BUTTON_ICON_SIZE = 12;
    private static final int BUTTON_ICON_SRC_X = 0;
    private static final int BUTTON_ICON_SRC_Y = 0;
    private static final int EDIT_BUTTONS_PER_ROW = 2;
    private static final int EDIT_BUTTONS_SRC_PER_ROW = 8;
    private final Runnable onClick;
    private final int x;
    private final int y;
    private final EditMode mode;
    private List<FormattedText> text;

    public EditButton(EditMode mode, int id, Runnable onClick) {
        this.mode = mode;
        this.onClick = onClick;
        int x = id % 2;
        int y = id / 2;
        this.x = -38 + x * 20;
        this.y = 5 + y * 20;
    }

    public static EditButton[] createButtons(Consumer<EditMode> setter, EditMode ... modes) {
        EditButton[] ret = new EditButton[modes.length];
        for (int i = 0; i < modes.length; ++i) {
            EditMode mode = modes[i];
            ret[i] = new EditButton(mode, i, () -> setter.accept(mode));
        }
        return ret;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiQuestBook gui, GuiGraphics graphics, int mX, int mY) {
        int srcY = gui.getCurrentMode() == this.mode ? 2 : (gui.inBounds(this.x, this.y, 16, 16, mX, mY) ? 1 : 0);
        gui.drawRect(graphics, GuiBase.MAP_TEXTURE, this.x, this.y, 240, srcY * 16, 16, 16);
        gui.drawRect(graphics, GuiBase.MAP_TEXTURE, this.x + 2, this.y + 2, 0 + this.mode.ordinal() % 8 * 12, 0 + this.mode.ordinal() / 8 * 12, 12, 12);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInfo(GuiQuestBook gui, GuiGraphics graphics, int mX, int mY) {
        if (gui.inBounds(this.x, this.y, 16, 16, mX, mY)) {
            if (this.text == null) {
                this.text = new ArrayList<FormattedText>();
                if (KeyboardHandler.keyMap.containsValue((Object)this.mode)) {
                    ArrayList<CallSite> builder = new ArrayList<CallSite>();
                    for (Map.Entry entry : KeyboardHandler.keyMap.entries()) {
                        if (entry.getValue() != this.mode) continue;
                        builder.add((CallSite)((Object)("\u00a77" + StringUtils.capitalize((String)InputConstants.Type.KEYSYM.m_84895_(((Integer)entry.getKey()).intValue()).m_84875_().getString()))));
                    }
                    this.text.add((FormattedText)Translator.translatable("hqm.editMode.keybind", this.mode.getName(), String.join((CharSequence)", ", builder)));
                } else {
                    this.text.add(FormattedText.m_130775_((String)this.mode.getName()));
                }
                this.text.addAll(gui.getLinesFromText(Translator.plain("\n" + this.mode.getDescription()), 1.0f, 150));
                for (int i = 1; i < this.text.size(); ++i) {
                    ComponentCollector collector = new ComponentCollector();
                    this.text.get(i).m_7451_((style, string) -> {
                        collector.m_90675_(FormattedText.m_130762_((String)string, (Style)style));
                        return Optional.empty();
                    }, Style.f_131099_);
                    this.text.set(i, collector.m_90677_());
                }
            }
            gui.renderTooltipL(graphics, this.text, mX + gui.getLeft(), mY + gui.getTop());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onClick(GuiQuestBook gui, int mX, int mY) {
        if (gui.inBounds(this.x, this.y, 16, 16, mX, mY)) {
            this.click();
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void click() {
        this.onClick.run();
    }

    public boolean matchesMode(EditMode mode) {
        return this.mode == mode;
    }
}

