/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import hardcorequesting.common.forge.client.EditButton;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.quests.Quest;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KeyboardHandler {
    public static Multimap<Integer, EditMode> keyMap = Multimaps.newMultimap((Map)Maps.newHashMap(), Lists::newArrayList);

    public static void initDefault() {
        KeyboardHandler.addKeymap(77, EditMode.MOVE);
        KeyboardHandler.addKeymap(82, EditMode.RENAME);
        KeyboardHandler.addKeymap(78, EditMode.CREATE);
        KeyboardHandler.addKeymap(260, EditMode.CREATE);
        KeyboardHandler.addKeymap(78, EditMode.TASK);
        KeyboardHandler.addKeymap(260, EditMode.TASK);
        KeyboardHandler.addKeymap(261, EditMode.DELETE);
        KeyboardHandler.addKeymap(68, EditMode.DELETE);
        KeyboardHandler.addKeymap(83, EditMode.SWAP_SELECT);
        KeyboardHandler.addKeymap(83, EditMode.SWAP);
        KeyboardHandler.addKeymap(82, EditMode.REQUIREMENT);
        KeyboardHandler.addKeymap(79, EditMode.QUEST_OPTION);
        KeyboardHandler.addKeymap(73, EditMode.ITEM);
        KeyboardHandler.addKeymap(76, EditMode.LOCATION);
        KeyboardHandler.addKeymap(67, EditMode.MOB);
        KeyboardHandler.addKeymap(32, EditMode.NORMAL);
        KeyboardHandler.addKeymap(66, EditMode.BAG);
        KeyboardHandler.addKeymap(82, EditMode.REPUTATION);
    }

    public static void clear() {
        if (keyMap != null) {
            keyMap.clear();
        }
    }

    private static void addKeymap(int key, EditMode mode) {
        keyMap.put((Object)key, (Object)mode);
    }

    public static boolean handleEditModeHotkey(int key, EditButton[] buttons) {
        if (Quest.canQuestsBeEdited()) {
            if (48 <= key && key <= 57) {
                int i;
                int n = i = key == 48 ? 9 : key - 49;
                if (i < buttons.length) {
                    buttons[i].click();
                    return true;
                }
            } else if (keyMap.containsKey((Object)key)) {
                Collection modes = keyMap.get((Object)key);
                for (EditButton button : buttons) {
                    for (EditMode mode : modes) {
                        if (!button.matchesMode(mode)) continue;
                        button.click();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static String[] toConfig() {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (Map.Entry entry : keyMap.entries()) {
            list.add((CallSite)((Object)(entry.getKey() + ":" + ((EditMode)((Object)entry.getValue())).name().toLowerCase())));
        }
        return list.toArray(new String[0]);
    }

    public static void fromConfig(String[] config) {
        KeyboardHandler.clear();
        for (String entry : config) {
            String[] split = entry.split(":");
            if (split.length != 2) continue;
            int key = Integer.parseInt(split[0]);
            EditMode mode = EditMode.valueOf(split[1].toUpperCase());
            if (mode == null) continue;
            KeyboardHandler.addKeymap(key, mode);
        }
    }

    public static String[] getDefault() {
        KeyboardHandler.initDefault();
        String[] map = KeyboardHandler.toConfig();
        KeyboardHandler.clear();
        return map;
    }
}

