/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client;

import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.Fluid;

public class TextSearch<T> {
    public static List<SearchEntry<ItemStack>> ITEMS = new ArrayList<SearchEntry<ItemStack>>();
    public static List<SearchEntry<FluidStack>> FLUIDS = new ArrayList<SearchEntry<FluidStack>>();
    private final String text;
    private final Supplier<Stream<SearchEntry<T>>> searchEntrySupplier;
    private final int limit;
    private final boolean advancedTooltips;

    public static <A, B> Stream<SearchEntry<B>> innerMap(Stream<SearchEntry<A>> stream, Function<A, B> mapper) {
        return stream.map(entry -> entry.map(mapper));
    }

    public static <T> List<T> search(String text, Supplier<Stream<SearchEntry<T>>> searchEntrySupplier, int limit) {
        return new TextSearch<T>(text, searchEntrySupplier, limit).doSearch();
    }

    private TextSearch(String text, Supplier<Stream<SearchEntry<T>>> searchEntrySupplier, int limit) {
        this.text = text;
        this.searchEntrySupplier = searchEntrySupplier;
        this.limit = limit;
        this.advancedTooltips = Minecraft.m_91087_().f_91066_.f_92125_;
    }

    private List<T> doSearch() {
        TextSearch.initItems();
        Pattern pattern = Pattern.compile(Pattern.quote(this.text), 2);
        return this.searchEntrySupplier.get().flatMap(entry -> entry.tryMatch(pattern, this.advancedTooltips)).limit(this.limit).collect(Collectors.toList());
    }

    public static void initItems() {
        if (ITEMS.isEmpty() || FLUIDS.isEmpty()) {
            TextSearch.clear();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            for (ItemStack stack : CreativeModeTabs.m_258007_().m_260957_()) {
                List tooltipList = stack.m_41651_((Player)player, (TooltipFlag)TooltipFlag.Default.f_256752_);
                List advTooltipList = stack.m_41651_((Player)player, (TooltipFlag)TooltipFlag.Default.f_256730_);
                StringBuilder searchString = new StringBuilder();
                for (Object string : tooltipList) {
                    if (string == null) continue;
                    searchString.append(string).append("\n");
                }
                StringBuilder advSearchString = new StringBuilder();
                for (Object string : advTooltipList) {
                    if (string == null) continue;
                    advSearchString.append(string).append("\n");
                }
                ITEMS.add(new SearchEntry<ItemStack>(searchString.toString(), advSearchString.toString(), stack));
            }
            for (Fluid fluid : BuiltInRegistries.f_257020_) {
                if (fluid instanceof EmptyFluid || !fluid.m_76145_().m_76170_()) continue;
                FluidStack fluidVolume = FluidStack.create((Fluid)fluid, (long)HardcoreQuestingCore.platform.getBucketAmount().intValue());
                String search = fluidVolume.getName().getString();
                FLUIDS.add(new SearchEntry<FluidStack>(search, search, fluidVolume));
            }
        }
    }

    public static void clear() {
        FLUIDS.clear();
        ITEMS.clear();
    }

    public static class SearchEntry<T> {
        private final String toolTip;
        private final String advToolTip;
        private final T element;

        public SearchEntry(String searchString, String advSearchString, T element) {
            this.toolTip = searchString;
            this.advToolTip = advSearchString;
            this.element = element;
        }

        public Stream<T> tryMatch(Pattern pattern, boolean advanced) {
            if (pattern.matcher(advanced ? this.advToolTip : this.toolTip).find()) {
                return Stream.of(this.element);
            }
            return Stream.empty();
        }

        public <R> SearchEntry<R> map(Function<T, R> mapper) {
            return new SearchEntry<R>(this.toolTip, this.advToolTip, mapper.apply(this.element));
        }
    }
}

