/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces;

import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.widget.ArrowSelectionHelper;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.client.interfaces.widget.NumberTextBox;
import hardcorequesting.common.forge.client.interfaces.widget.TextBoxGroup;
import hardcorequesting.common.forge.tileentity.TrackerBlockEntity;
import hardcorequesting.common.forge.tileentity.TrackerType;
import hardcorequesting.common.forge.util.HQMUtil;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EditTrackerScreen
extends GuiBase {
    public static final ResourceLocation BG_TEXTURE = ResourceHelper.getResource("wrapper");
    public static final ResourceLocation C_BG_TEXTURE = ResourceHelper.getResource("c_wrapper");
    private static final int TEXTURE_WIDTH = 170;
    private static final int TEXTURE_HEIGHT = 234;
    private final TrackerBlockEntity tracker;
    private final ArrowSelectionHelper selectionHelper;
    private final List<LargeButton> buttons = new ArrayList<LargeButton>();
    private final TextBoxGroup textBoxes = new TextBoxGroup();

    public EditTrackerScreen(TrackerBlockEntity trackerIn) {
        super(CommonComponents.f_237098_);
        this.tracker = trackerIn;
        this.selectionHelper = new ArrowSelectionHelper(this, 20, 30){

            @Override
            protected void onArrowClick(boolean left) {
                if (left) {
                    EditTrackerScreen.this.tracker.setTrackerType((TrackerType)HQMUtil.cyclePrev((Enum[])TrackerType.values(), (Enum)EditTrackerScreen.this.tracker.getTrackerType()));
                } else {
                    EditTrackerScreen.this.tracker.setTrackerType((TrackerType)HQMUtil.cycleNext((Enum[])TrackerType.values(), (Enum)EditTrackerScreen.this.tracker.getTrackerType()));
                }
            }

            @Override
            protected FormattedText getArrowText() {
                return EditTrackerScreen.this.tracker.getTrackerType().getName();
            }

            @Override
            protected FormattedText getArrowDescription() {
                return EditTrackerScreen.this.tracker.getTrackerType().getDescription();
            }
        };
        this.buttons.add(new LargeButton(this, "hqm.edit.ok", 40, 200){

            @Override
            public void onClick() {
                EditTrackerScreen.this.tracker.sendToServer();
                EditTrackerScreen.this.m_7379_();
            }
        });
        this.buttons.add(new LargeButton(this, "hqm.edit.cancel", 100, 200){

            @Override
            public void onClick() {
                EditTrackerScreen.this.m_7379_();
            }
        });
    }

    protected void m_7856_() {
        super.m_7856_();
        this.left = (this.f_96543_ - 170) / 2;
        this.top = (this.f_96544_ - 234) / 2;
        if (this.textBoxes.getTextBoxes().isEmpty()) {
            this.textBoxes.add(new NumberTextBox(this, 20, 130, (FormattedText)Translator.translatable("hqm.menuTracker.radius.title", new Object[0]), this.tracker::getRadius, this.tracker::setRadius){

                @Override
                protected void draw(GuiGraphics graphics, boolean selected, int mX, int mY) {
                    super.draw(graphics, selected, mX, mY);
                    this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.menuTracker.radius.desc", new Object[0]), 0.7f, 130), this.x, this.y + 30 + -10, 0.7f, 0x404040);
                }
            });
        }
    }

    public void m_88315_(GuiGraphics graphics, int mX0, int mY0, float f) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawRect(graphics, BG_TEXTURE, 0, 0, 0, 0, 170, 234);
        int mX = mX0 - this.left;
        int mY = mY0 - this.top;
        for (LargeButton button : this.buttons) {
            button.render(graphics, mX, mY);
        }
        this.textBoxes.render(graphics, mX, mY);
        this.drawCenteredString(graphics, (FormattedText)(this.tracker.getCurrentQuest() != null ? this.tracker.getCurrentQuest().getName() : Translator.translatable("hqm.menuTracker.noQuest", new Object[0])), 0, 5, 1.0f, 170, 20, 0x404040);
        this.selectionHelper.render(graphics, mX, mY);
        for (LargeButton button : this.buttons) {
            button.renderTooltip(graphics, mX, mY);
        }
    }

    public boolean m_5534_(char c, int k) {
        if (super.m_5534_(c, k)) {
            return true;
        }
        return this.textBoxes.onCharTyped(c);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.textBoxes.onKeyStroke(keyCode);
    }

    public boolean m_6375_(double mX0, double mY0, int b) {
        int mX = (int)(mX0 - (double)this.left);
        int mY = (int)(mY0 - (double)this.top);
        for (LargeButton button : this.buttons) {
            if (!button.onClick(mX, mY)) continue;
            return true;
        }
        return this.textBoxes.onClick(mX, mY) || this.selectionHelper.onClick(mX, mY) || super.m_6375_(mX0, mY0, b);
    }

    public boolean m_6348_(double mX0, double mY0, int b) {
        int mX = (int)(mX0 - (double)this.left);
        int mY = (int)(mY0 - (double)this.top);
        return this.selectionHelper.onRelease(mX, mY) || super.m_6348_(mX0, mY0, b);
    }

    public boolean m_7043_() {
        return false;
    }
}

