/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import hardcorequesting.common.forge.client.interfaces.RenderRotation;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.util.FluidUtils;
import hardcorequesting.common.forge.util.Translator;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class GuiBase
extends Screen {
    public static final ResourceLocation MAP_TEXTURE = ResourceHelper.getResource("questmap");
    public static final int TEXT_HEIGHT = 9;
    public static final int ITEM_SIZE = 18;
    protected static final int ITEM_SRC_Y = 235;
    protected int left;
    protected int top;

    protected GuiBase(Component title) {
        super(title);
    }

    public void drawRect(GuiGraphics graphics, ResourceLocation texture, int x, int y, int u, int v, int w, int h) {
        graphics.m_280218_(texture, x + this.left, y + this.top, u, v, w, h);
    }

    public void drawRect(GuiGraphics graphics, int x, int y, int u, int v, int w, int h, RenderRotation rotation) {
        double[] pt3;
        double[] pt2;
        double[] pt1;
        boolean rotate = rotation == RenderRotation.ROTATE_90 || rotation == RenderRotation.ROTATE_270 || rotation == RenderRotation.ROTATE_90_FLIP || rotation == RenderRotation.ROTATE_270_FLIP;
        int targetW = rotate ? h : w;
        int targetH = rotate ? w : h;
        x += this.left;
        y += this.top;
        float fw = 0.00390625f;
        float fy = 0.00390625f;
        double a = (float)u * fw;
        double b = (float)(u + w) * fw;
        double c = (float)(v + h) * fy;
        double d = (float)v * fy;
        double[] ptA = new double[]{a, c};
        double[] ptB = new double[]{b, c};
        double[] ptC = new double[]{b, d};
        double[] ptD = new double[]{a, d};
        double[] pt4 = switch (rotation) {
            default -> {
                pt1 = ptA;
                pt2 = ptB;
                pt3 = ptC;
                yield ptD;
            }
            case RenderRotation.ROTATE_90 -> {
                pt1 = ptB;
                pt2 = ptC;
                pt3 = ptD;
                yield ptA;
            }
            case RenderRotation.ROTATE_180 -> {
                pt1 = ptC;
                pt2 = ptD;
                pt3 = ptA;
                yield ptB;
            }
            case RenderRotation.ROTATE_270 -> {
                pt1 = ptD;
                pt2 = ptA;
                pt3 = ptB;
                yield ptC;
            }
            case RenderRotation.FLIP_HORIZONTAL -> {
                pt1 = ptB;
                pt2 = ptA;
                pt3 = ptD;
                yield ptC;
            }
            case RenderRotation.ROTATE_90_FLIP -> {
                pt1 = ptA;
                pt2 = ptD;
                pt3 = ptC;
                yield ptB;
            }
            case RenderRotation.FLIP_VERTICAL -> {
                pt1 = ptD;
                pt2 = ptC;
                pt3 = ptB;
                yield ptA;
            }
            case RenderRotation.ROTATE_270_FLIP -> {
                pt1 = ptC;
                pt2 = ptB;
                pt3 = ptA;
                yield ptD;
            }
        };
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)x, (float)(y + targetH), 0.0f).m_7421_((float)pt1[0], (float)pt1[1]).m_5752_();
        bufferBuilder.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)(x + targetW), (float)(y + targetH), 0.0f).m_7421_((float)pt2[0], (float)pt2[1]).m_5752_();
        bufferBuilder.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)(x + targetW), (float)y, 0.0f).m_7421_((float)pt3[0], (float)pt3[1]).m_5752_();
        bufferBuilder.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)x, (float)y, 0.0f).m_7421_((float)pt4[0], (float)pt4[1]).m_5752_();
        tesselator.m_85914_();
    }

    public void renderTooltip(GuiGraphics graphics, FormattedText stringRenderable, int x, int y) {
        this.renderTooltipL(graphics, this.f_96547_.m_92865_().m_92414_(stringRenderable, Integer.MAX_VALUE, Style.f_131099_), x, y);
    }

    public void renderTooltipL(GuiGraphics graphics, List<? extends FormattedText> stringRenderables, int x, int y) {
        graphics.m_280245_(this.f_96547_, Language.m_128107_().m_128112_(stringRenderables), x, y);
    }

    public void drawLine(GuiGraphics graphics, int x1, int y1, int x2, int y2, int thickness, int color) {
        if (y2 < y1) {
            this.drawLine(graphics, x2, y2, x1, y1, thickness, color);
            return;
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        this.applyColor(color);
        RenderSystem.setShader(GameRenderer::m_172757_);
        float scale = (float)this.f_96541_.m_91268_().m_85449_();
        RenderSystem.lineWidth((float)(1.0f + (float)thickness * scale / 2.0f));
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
        builder.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)x1, (float)y1, 0.0f).m_6122_(255, 255, 255, 255).m_5601_((float)dx, (float)dy, 0.0f).m_5752_();
        builder.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)x2, (float)y2, 0.0f).m_6122_(255, 255, 255, 255).m_5601_((float)dx, (float)dy, 0.0f).m_5752_();
        tesselator.m_85914_();
    }

    public void drawFluid(FluidStack fluid, GuiGraphics graphics, int x, int y, int mX, int mY) {
        this.drawItemBackground(graphics, x, y, mX, mY, false);
        if (fluid != null) {
            this.drawFluid(fluid, graphics.m_280168_(), x + 1, y + 1);
        }
    }

    public void drawFluid(FluidStack fluid, PoseStack stack, int x, int y) {
        stack.m_85836_();
        stack.m_252880_(0.0f, 0.0f, 0.0f);
        int x1 = this.getLeft() + x;
        int y1 = this.getTop() + y;
        int x2 = this.getLeft() + x + 16;
        int y2 = this.getTop() + y + 16;
        TextureAtlasSprite sprite = FluidStackHooks.getStillTexture((FluidStack)fluid);
        int color = FluidStackHooks.getColor((FluidStack)fluid);
        int a = 255;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        MultiBufferSource.BufferSource source = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer builder = FluidUtils.getBlockMaterial(sprite.m_247685_()).m_119194_((MultiBufferSource)source, FluidUtils.CustomRenderTypes::createFluid);
        Matrix4f matrix = stack.m_85850_().m_252922_();
        builder.m_252986_(matrix, (float)x2, (float)y1, 0.0f).m_6122_(r, g, b, a).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
        builder.m_252986_(matrix, (float)x1, (float)y1, 0.0f).m_6122_(r, g, b, a).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
        builder.m_252986_(matrix, (float)x1, (float)y2, 0.0f).m_6122_(r, g, b, a).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
        builder.m_252986_(matrix, (float)x2, (float)y2, 0.0f).m_6122_(r, g, b, a).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
        source.m_109911_();
        stack.m_85849_();
    }

    public void applyColor(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public void drawItemBackground(GuiGraphics graphics, int x, int y, int mX, int mY, boolean selected) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawRect(graphics, MAP_TEXTURE, x, y, this.inBounds(x, y, 18, 18, mX, mY) ? 18 : 0, 235, 18, 18);
        if (selected) {
            this.drawRect(graphics, MAP_TEXTURE, x, y, 36, 235, 18, 18);
        }
    }

    public void drawItemStack(GuiGraphics graphics, ItemStack stack, int x, int y, int mX, int mY, boolean selected) {
        this.drawItemBackground(graphics, x, y, mX, mY, selected);
        if (!stack.m_41619_()) {
            this.drawItemStack(graphics, stack, x + 1, y + 1, true);
        }
    }

    protected void setColor(int color) {
        float[] colorComponents = new float[3];
        for (int i = 0; i < colorComponents.length; ++i) {
            colorComponents[i] = (float)((color & 255 << i * 8) >> i * 8) / 255.0f;
        }
        RenderSystem.setShaderColor((float)colorComponents[2], (float)colorComponents[1], (float)colorComponents[0], (float)1.0f);
    }

    public void drawItemStack(GuiGraphics graphics, @NotNull ItemStack stack, int x, int y, boolean renderEffect) {
        graphics.m_280480_(stack, this.getLeft() + x, this.getTop() + y);
        graphics.m_280370_(this.f_96547_, stack, this.getLeft() + x, this.getTop() + y);
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getStringWidth(String txt) {
        return this.f_96547_.m_92895_(txt);
    }

    public int getStringWidth(FormattedText txt) {
        return this.f_96547_.m_92852_(txt);
    }

    public void drawString(GuiGraphics graphics, FormattedText str, int x, int y, int color) {
        this.drawString(graphics, str, x, y, 1.0f, color);
    }

    public void drawString(GuiGraphics graphics, FormattedText str, int x, int y, float mult, int color) {
        this.drawString(graphics, str, x, y, false, mult, color);
    }

    public void drawString(GuiGraphics graphics, FormattedText str, int x, int y, boolean shadow, float mult, int color) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(mult, mult, 1.0f);
        FormattedCharSequence text = str.getString().isEmpty() ? FormattedCharSequence.f_13691_ : Language.m_128107_().m_5536_(str);
        float drawX = (float)(x + this.left) / mult;
        float drawY = (float)(y + this.top) / mult;
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        this.f_96547_.m_272191_(text, drawX, drawY, color, shadow, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        bufferSource.m_109911_();
        graphics.m_280168_().m_85849_();
    }

    public void drawStringWithShadow(GuiGraphics graphics, FormattedText str, int x, int y, float mult, int color) {
        this.drawString(graphics, str, x, y, true, mult, color);
    }

    public void drawString(GuiGraphics graphics, String str, int x, int y, int color) {
        this.drawString(graphics, str, x, y, 1.0f, color);
    }

    public void drawString(GuiGraphics graphics, String str, int x, int y, float mult, int color) {
        this.drawString(graphics, str == null ? FormattedText.f_130760_ : FormattedText.m_130775_((String)str), x, y, mult, color);
    }

    public void drawStringWithShadow(GuiGraphics graphics, String str, int x, int y, float mult, int color) {
        this.drawStringWithShadow(graphics, str == null ? FormattedText.f_130760_ : FormattedText.m_130775_((String)str), x, y, mult, color);
    }

    public boolean inBounds(int x, int y, int w, int h, double mX, double mY) {
        return (double)x <= mX && mX <= (double)(x + w) && (double)y <= mY && mY <= (double)(y + h);
    }

    public void drawCursor(GuiGraphics graphics, int x, int y, int z, float size, int color) {
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, (float)z);
        pose.m_252880_((float)(x += this.left), (float)(y += this.top), 0.0f);
        pose.m_85841_(size, size, 0.0f);
        pose.m_252880_((float)(-x), (float)(-y), 0.0f);
        graphics.m_280509_(x, y + 1, x + 1, y + 10, color);
        pose.m_85849_();
    }

    public void drawSelection(GuiGraphics graphics, Collection<Rect2i> areas) {
        PoseStack matrices = graphics.m_280168_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (Rect2i area : areas) {
            int x0 = area.m_110085_() + this.left;
            int y0 = area.m_110086_() + this.top;
            int x1 = x0 + area.m_110090_();
            int y1 = y0 + area.m_110091_();
            bufferBuilder.m_252986_(matrices.m_85850_().m_252922_(), (float)x0, (float)y1, 0.0f).m_5752_();
            bufferBuilder.m_252986_(matrices.m_85850_().m_252922_(), (float)x1, (float)y1, 0.0f).m_5752_();
            bufferBuilder.m_252986_(matrices.m_85850_().m_252922_(), (float)x1, (float)y0, 0.0f).m_5752_();
            bufferBuilder.m_252986_(matrices.m_85850_().m_252922_(), (float)x0, (float)y0, 0.0f).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.disableColorLogicOp();
    }

    public void drawString(GuiGraphics graphics, List<FormattedText> str, int x, int y, float mult, int color) {
        this.drawString(graphics, str, 0, str.size(), x, y, mult, color);
    }

    public void drawString(GuiGraphics graphics, List<FormattedText> str, int start, int length, int x, int y, float mult, int color) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(mult, mult, 1.0f);
        start = Math.max(start, 0);
        int end = Math.min(start + length, str.size());
        for (int i = start; i < end; ++i) {
            graphics.m_280649_(this.f_96547_, Language.m_128107_().m_5536_(str.get(i)), (int)((float)(x + this.left) / mult), (int)((float)(y + this.top) / mult), color, false);
            Objects.requireNonNull(this.f_96547_);
            y += 9;
        }
        graphics.m_280168_().m_85849_();
    }

    public void drawCenteredString(GuiGraphics graphics, FormattedText str, int x, int y, float mult, int width, int height, int color) {
        int n = x + (width - (int)((float)this.f_96547_.m_92852_(str) * mult)) / 2;
        Objects.requireNonNull(this.f_96547_);
        this.drawString(graphics, str, n, y + (height - (int)((float)(9 - 2) * mult)) / 2, mult, color);
    }

    public List<FormattedText> getLinesFromText(FormattedText str, float mult, int width) {
        if (str == null) {
            str = Translator.plain("Missing info");
        }
        return this.f_96547_.m_92865_().m_92414_(str, (int)((float)width / mult), Style.f_131099_);
    }

    public Font getFont() {
        return this.f_96547_;
    }
}

