/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.client.BookPage;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.RenderRotation;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.EditReputationGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.Graphic;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.client.sounds.SoundHandler;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestSet;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.reputation.ReputationBar;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GuiQuestBook
extends GuiBase {
    public static final int PAGE_WIDTH = 170;
    public static final int TEXTURE_WIDTH = 340;
    public static final int TEXTURE_HEIGHT = 234;
    private static final int BACK_ARROW_X = 9;
    private static final int BACK_ARROW_Y = 219;
    private static final int BACK_ARROW_SRC_X = 0;
    private static final int BACK_ARROW_SRC_Y = 113;
    private static final int BACK_ARROW_WIDTH = 15;
    private static final int BACK_ARROW_HEIGHT = 10;
    private static final int MENU_ARROW_X = 161;
    private static final int MENU_ARROW_Y = 217;
    private static final int MENU_ARROW_SRC_X = 0;
    private static final int MENU_ARROW_SRC_Y = 104;
    private static final int MENU_ARROW_WIDTH = 14;
    private static final int MENU_ARROW_HEIGHT = 9;
    private static final ResourceLocation BG_TEXTURE = ResourceHelper.getResource("book");
    @NotNull
    private static BookPage page = BookPage.MainPage.INSTANCE;
    private Graphic pageGraphic;
    public final boolean isOpBook;
    private final Player player;
    public QuestSet modifyingQuestSet;
    public ReputationBar modifyingBar;
    private int tick;
    private GuiEditMenu editMenu;
    private final LargeButton saveButton;
    private EditMode currentMode = EditMode.NORMAL;

    private GuiQuestBook(Player player, boolean isOpBook) {
        super(CommonComponents.f_237098_);
        this.saveButton = new LargeButton(this, "hqm.questBook.saveAll", 360, 10){

            @Override
            public boolean isVisible() {
                return Quest.canQuestsBeEdited() && SaveHelper.isLarge();
            }

            @Override
            public void onClick() {
                GuiQuestBook.this.save();
            }
        };
        this.player = player;
        this.isOpBook = isOpBook;
    }

    public static void resetBookPosition() {
        page = BookPage.MainPage.INSTANCE;
        EditReputationGraphic.selectedReputation = null;
    }

    public static void displayGui(Player player, boolean isOpBook) {
        if (player != null) {
            Minecraft mc = Minecraft.m_91087_();
            if (!(mc.f_91080_ instanceof GuiQuestBook)) {
                mc.m_91152_((Screen)new GuiQuestBook(player, isOpBook));
            }
        }
    }

    protected void m_7856_() {
        if (this.pageGraphic == null) {
            this.pageGraphic = page.createGraphic(this);
        }
        QuestingData data = QuestingDataManager.getInstance().getQuestingData(this.player);
        if (!data.playedLore && SoundHandler.hasLoreMusic()) {
            SoundHandler.triggerFirstLore();
            data.playedLore = true;
        }
    }

    public void m_7861_() {
        SoundHandler.stopLoreMusic();
    }

    public int getTick() {
        return this.tick;
    }

    public void setEditMenu(GuiEditMenu editMenu) {
        this.editMenu = editMenu;
    }

    public void m_88315_(GuiGraphics graphics, int x0, int y0, float f) {
        this.left = (this.f_96543_ - 340) / 2;
        this.top = (this.f_96544_ - 234) / 2;
        int x = x0 - this.left;
        int y = y0 - this.top;
        this.applyColor(-1);
        this.drawRect(graphics, BG_TEXTURE, 0, 0, 0, 0, 170, 234);
        ResourceHelper.bindResource(BG_TEXTURE);
        this.drawRect(graphics, 170, 0, 0, 0, 170, 234, RenderRotation.FLIP_HORIZONTAL);
        if (Quest.canQuestsBeEdited()) {
            this.applyColor(-1);
            ResourceHelper.bindResource(MAP_TEXTURE);
            SaveHelper.render(graphics, this, x, y);
        }
        this.saveButton.render(graphics, x, y);
        this.applyColor(-1);
        if (this.shouldDisplayBackArrow()) {
            this.drawRect(graphics, MAP_TEXTURE, 9, 219, 0 + (this.inBackArrowBounds(x, y) ? 15 : 0), 113, 15, 10);
        }
        if (this.shouldDisplayMenuArrow()) {
            this.drawRect(graphics, MAP_TEXTURE, 161, 217, 0 + (this.inMenuArrowBounds(x, y) ? 14 : 0), 104, 14, 9);
        }
        if (this.editMenu == null) {
            this.pageGraphic.drawFull(graphics, x, y);
            if (this.currentMode == EditMode.DELETE) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
                this.drawCenteredString(graphics, (FormattedText)Translator.translatable("hqm.questBook.warning", new Object[0]), 0, 0, 2.0f, 340, 234, 0xFF0000);
                MutableComponent mutableComponent = Translator.translatable("hqm.questBook.deleteOnClick", new Object[0]);
                Objects.requireNonNull(this.f_96547_);
                this.drawCenteredString(graphics, (FormattedText)mutableComponent, 0, 9 * 2, 1.0f, 340, 234, 0xFF0000);
                graphics.m_280168_().m_85849_();
            }
        } else {
            this.editMenu.drawFull(graphics, x, y);
        }
        this.saveButton.renderTooltip(graphics, x, y);
        if (this.shouldDisplayBackArrow() && this.inBackArrowBounds(x, y)) {
            this.renderTooltip(graphics, FormattedText.m_130773_((FormattedText[])new FormattedText[]{Translator.translatable("hqm.questBook.goBack", new Object[0]), Translator.plain("\n"), Translator.translatable("hqm.questBook.rightClick", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY)}), x + this.left, y + this.top);
        } else if (this.shouldDisplayMenuArrow() && this.inMenuArrowBounds(x, y)) {
            this.renderTooltip(graphics, (FormattedText)Translator.translatable("hqm.questBook.backToMenu", new Object[0]), x + this.left, y + this.top);
        }
    }

    public boolean m_5534_(char c, int k) {
        if (super.m_5534_(c, k)) {
            return true;
        }
        if (this.editMenu == null) {
            return this.pageGraphic.charTyped(c);
        }
        this.editMenu.charTyped(c);
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.editMenu != null) {
            return this.editMenu.keyPressed(keyCode);
        }
        if (this.pageGraphic.keyPressed(keyCode)) {
            return true;
        }
        if (keyCode == 259) {
            this.goBack();
            return true;
        }
        return false;
    }

    public boolean m_6375_(double x0, double y0, int button) {
        if (super.m_6375_(x0, y0, button)) {
            return true;
        }
        int x = (int)(x0 - (double)this.left);
        int y = (int)(y0 - (double)this.top);
        if (this.shouldDisplayBackArrow() && this.inBackArrowBounds(x, y)) {
            button = 1;
            if (this.editMenu != null) {
                this.editMenu.save();
                this.editMenu.close();
                return true;
            }
        } else if (this.shouldDisplayMenuArrow() && this.inMenuArrowBounds(x, y)) {
            if (this.editMenu != null) {
                this.editMenu.save();
                this.editMenu.close();
                this.editMenu = null;
            }
            this.setPage(BookPage.MenuPage.INSTANCE);
            return true;
        }
        boolean buttonClicked = this.saveButton.onClick(x, y);
        if (Quest.canQuestsBeEdited()) {
            SaveHelper.onClick(this, x, y);
        }
        if (buttonClicked) {
            return true;
        }
        if (this.editMenu == null) {
            if (button == 1) {
                this.goBack();
                return true;
            }
            this.pageGraphic.onClick(x, y, button);
        } else {
            this.editMenu.onClick(x, y, button);
        }
        return true;
    }

    public boolean m_6348_(double x0, double y0, int button) {
        if (super.m_6348_(x0, y0, button)) {
            return true;
        }
        int x = (int)(x0 - (double)this.left);
        int y = (int)(y0 - (double)this.top);
        this.updatePosition(x, y);
        if (this.currentMode == EditMode.MOVE) {
            this.modifyingBar = null;
        }
        if (this.editMenu != null) {
            this.editMenu.onRelease(x, y, button);
        } else {
            this.pageGraphic.onRelease(x, y, button);
        }
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        int x = (int)(mouseX - (double)this.left);
        int y = (int)(mouseY - (double)this.top);
        this.updatePosition(x, y);
        if (this.editMenu != null) {
            this.editMenu.onDrag(x, y, button);
        } else {
            this.pageGraphic.onDrag(x, y, button);
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        double mX = mouseX - (double)this.left;
        double mY = mouseY - (double)this.top;
        if (this.editMenu != null) {
            this.editMenu.onScroll(mX, mY, scroll);
        } else {
            this.pageGraphic.onScroll(mX, mY, scroll);
        }
        return true;
    }

    public void m_86600_() {
        ++this.tick;
        super.m_86600_();
    }

    public boolean m_7043_() {
        return false;
    }

    public void goBack() {
        if (page.canGoBack()) {
            this.setPage(page.getParent());
        }
    }

    private void updatePosition(int x, int y) {
        if (Quest.canQuestsBeEdited() && this.currentMode == EditMode.MOVE && this.modifyingBar != null) {
            this.modifyingBar.moveTo(x, y);
        }
    }

    public EditMode getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentMode(EditMode mode) {
        this.currentMode = mode;
        this.modifyingBar = null;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void save() {
        QuestLine.getActiveQuestLine().saveQuests(HardcoreQuestingCore.packManager);
        SaveHelper.onSave();
    }

    private boolean shouldDisplayMenuArrow() {
        return this.shouldDisplayBackArrow() && page.hasGoToMenuButton();
    }

    private boolean shouldDisplayBackArrow() {
        return page.canGoBack() && this.editMenu == null;
    }

    private boolean inMenuArrowBounds(int mX, int mY) {
        return this.inBounds(161, 217, 14, 9, mX, mY);
    }

    private boolean inBackArrowBounds(int mX, int mY) {
        return this.inBounds(9, 219, 15, 10, mX, mY);
    }

    public void setPage(BookPage page) {
        GuiQuestBook.page = Objects.requireNonNull(page);
        this.pageGraphic = page.createGraphic(this);
    }
}

