/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces;

import hardcorequesting.common.forge.bag.LootGroup;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.items.BagItem;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class GuiReward
extends GuiBase {
    public static final ResourceLocation TEXTURE = ResourceHelper.getResource("reward");
    public static final ResourceLocation C_TEXTURE = ResourceHelper.getResource("c_reward");
    private static final int ITEMS_PER_LINE = 7;
    private static final int ITEM_SIZE = 16;
    private static final int ITEM_MARGIN = 5;
    private static final int TOP_HEIGHT = 52;
    private static final int MIDDLE_HEIGHT = 22;
    private static final int BOTTOM_HEIGHT = 24;
    private static final int TITLE_HEIGHT = 25;
    private static final int TOP_SRC_Y = 0;
    private static final int MIDDLE_SRC_Y = 67;
    private static final int BOTTOM_SRC_Y = 107;
    private static final int TEXTURE_WIDTH = 170;
    private LootGroup group;
    private int lines;
    private List<Reward> rewards;
    private FormattedText statisticsText;

    public GuiReward(LootGroup group, int bagTier, Player player) {
        super(CommonComponents.f_237098_);
        this.group = group;
        this.rewards = new ArrayList<Reward>();
        int totalWeight = 0;
        for (LootGroup other : LootGroup.getGroups().values()) {
            if (!other.isValid(player)) continue;
            totalWeight += other.getTier().getWeights()[bagTier];
        }
        int myWeight = group.getTier().getWeights()[bagTier];
        float chance = (float)myWeight / (float)totalWeight;
        this.statisticsText = Translator.translatable("hqm.rewardGui.chance", Float.valueOf((float)((int)(chance * 10000.0f)) / 100.0f));
        this.lines = (int)Math.ceil((float)group.getItems().size() / 7.0f);
        for (int i = 0; i < this.lines; ++i) {
            int y = 52 + 22 * i + 3;
            int itemsInLine = Math.min(group.getItems().size() - i * 7, 7);
            for (int j = 0; j < itemsInLine; ++j) {
                int x = (170 - (itemsInLine * 16 + (itemsInLine - 1) * 5)) / 2 + j * 21;
                ItemStack stack = (ItemStack)group.getItems().get(i * 7 + j);
                if (stack.m_41619_()) continue;
                this.rewards.add(new Reward(stack, x, y));
            }
        }
    }

    public static void open(Player player, UUID groupId, int bag, int[] limits) {
        LootGroup rewardGroup = LootGroup.getGroups().get(groupId);
        int i = 0;
        for (LootGroup group : LootGroup.getGroups().values()) {
            if (group.getLimit() == 0) continue;
            group.setRetrievalCount(player, limits[i++]);
        }
        if (BagItem.displayGui && rewardGroup != null) {
            Minecraft.m_91087_().m_91152_((Screen)new GuiReward(rewardGroup, bag, player));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mX0, int mY0, float f) {
        this.applyColor(-1);
        int height = 52 + 22 * this.lines + 24;
        this.left = (this.f_96543_ - 170) / 2;
        this.top = (this.f_96544_ - height) / 2;
        this.drawRect(graphics, TEXTURE, 0, 0, 0, 0, 170, 52);
        for (int i = 0; i < this.lines; ++i) {
            this.drawRect(graphics, TEXTURE, 0, 52 + i * 22, 0, 67, 170, 22);
        }
        this.drawRect(graphics, TEXTURE, 0, 52 + this.lines * 22, 0, 107, 170, 24);
        int mX = mX0 - this.left;
        int mY = mY0 - this.top;
        Object title = HQMConfig.getInstance().Loot.ALWAYS_USE_TIER || !this.group.hasName() ? Translator.translatable("hqm.rewardGui.tierReward", this.group.getTier().getName()) : this.group.getDisplayName();
        this.drawCenteredString(graphics, (FormattedText)title, 0, 0, 1.0f, 170, 25, this.group.getTier().getColor().getHexColor());
        this.drawCenteredString(graphics, this.statisticsText, 0, 25, 0.7f, 170, 27, 0x707070);
        this.drawCenteredString(graphics, (FormattedText)Translator.translatable("hqm.rewardGui.close", new Object[0]), 0, 52 + this.lines * 22, 0.7f, 170, 24, 0x707070);
        for (Reward reward : this.rewards) {
            try {
                this.drawItemStack(graphics, reward.stack, reward.x, reward.y, true);
            }
            catch (Throwable throwable) {}
        }
        for (Reward reward : this.rewards) {
            if (!this.inBounds(reward.x, reward.y, 16, 16, mX, mY)) continue;
            try {
                if (Screen.m_96638_()) {
                    graphics.m_280153_(this.getFont(), reward.stack, mX0, mY0);
                    continue;
                }
                ArrayList<FormattedCharSequence> str = new ArrayList<FormattedCharSequence>();
                try {
                    List info = reward.stack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(this.f_96541_.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
                    if (info.size() > 0) {
                        str.add(Language.m_128107_().m_5536_((FormattedText)info.get(0)));
                        if (info.size() > 1) {
                            str.add(Language.m_128107_().m_5536_((FormattedText)Translator.translatable("hqm.rewardGui.shiftInfo", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY)));
                        }
                    }
                    graphics.m_280245_(this.f_96547_, str, mX0, mY0);
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean m_6375_(double mX0, double mY0, int b) {
        Minecraft.m_91087_().m_91152_(null);
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    private static class Reward {
        private ItemStack stack;
        private int x;
        private int y;

        private Reward(ItemStack stack, int x, int y) {
            this.stack = stack;
            this.x = x;
            this.y = y;
        }
    }
}

