/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import hardcorequesting.common.forge.bag.BagTier;
import hardcorequesting.common.forge.bag.GroupTier;
import hardcorequesting.common.forge.bag.TierColor;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.client.interfaces.widget.ArrowSelectionHelper;
import hardcorequesting.common.forge.client.interfaces.widget.NumberTextBox;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.HQMUtil;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;

public class EditBagTierMenu
extends GuiEditMenu {
    private static final int TIERS_TEXT_X = 20;
    private static final int TIERS_TEXT_Y = 20;
    private static final int TIERS_WEIGHTS_X = 30;
    private static final int TIERS_WEIGHTS_Y = 80;
    private static final int TIERS_WEIGHTS_SPACING = 15;
    private static final int TIERS_TEXT_BOX_X = 65;
    private static final int TIERS_TEXT_BOX_Y = -2;
    private static final int TIERS_WEIGHTS_TEXT_Y = 65;
    private final GroupTier tier;
    private final GroupTier original;

    public static void display(GuiQuestBook gui, GroupTier original) {
        gui.setEditMenu(new EditBagTierMenu(gui, original));
    }

    private EditBagTierMenu(GuiQuestBook gui, GroupTier original) {
        super(gui, true);
        this.original = original;
        this.tier = original.copy();
        BagTier[] values = BagTier.values();
        int i = 0;
        while (i < values.length) {
            int id = i++;
            this.addTextBox(new NumberTextBox(gui, 95, 80 + 15 * id + -2, FormattedText.f_130760_, false, 6, () -> this.tier.getWeights()[id], value -> {
                this.tier.getWeights()[id] = value;
            }));
        }
        this.addClickable(new ArrowSelectionHelper(gui, 20, 40){

            @Override
            protected void onArrowClick(boolean left) {
                if (left) {
                    EditBagTierMenu.this.tier.setColor((TierColor)HQMUtil.cyclePrev((Enum[])TierColor.values(), (Enum)EditBagTierMenu.this.tier.getColor()));
                } else {
                    EditBagTierMenu.this.tier.setColor((TierColor)HQMUtil.cycleNext((Enum[])TierColor.values(), (Enum)EditBagTierMenu.this.tier.getColor()));
                }
            }

            @Override
            protected FormattedText getArrowText() {
                return Translator.plain(EditBagTierMenu.this.tier.getColor().getName());
            }
        });
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        this.gui.drawString(graphics, (FormattedText)this.tier.getName(), 20, 20, this.tier.getColor().getHexColor());
        this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.menuTier.weights", new Object[0]), 20, 65, 0x404040);
        BagTier[] values = BagTier.values();
        for (int i = 0; i < values.length; ++i) {
            BagTier bagTier = values[i];
            int posY = 80 + i * 15;
            this.gui.drawString(graphics, (FormattedText)bagTier.getColoredName(), 30, posY, 0x404040);
        }
    }

    @Override
    public void save() {
        this.original.load(this.tier);
        SaveHelper.add(EditType.TIER_CHANGE);
    }
}

