/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.AbstractTextMenu;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.ComponentCollector;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;

public class EditCommandRewardsMenu
extends AbstractTextMenu {
    private static final int START_X = 190;
    private static final int START_Y = 65;
    private static final int END_X = 300;
    private static final int LINE_HEIGHT = 10;
    private final Quest quest;
    private int id;
    private final List<Entry> commands;
    private String added;

    public static void display(GuiQuestBook gui, Quest quest) {
        gui.setEditMenu(new EditCommandRewardsMenu(gui, quest));
    }

    private EditCommandRewardsMenu(GuiQuestBook gui, Quest quest) {
        super(gui, "", false);
        this.quest = quest;
        this.commands = this.quest.getRewards().getCommandRewardsAsStrings().stream().map(s -> new Entry((String)s, false)).collect(Collectors.toCollection(ArrayList::new));
        this.id = -1;
        if (gui.getCurrentMode() == EditMode.COMMAND_CHANGE && !this.commands.isEmpty()) {
            this.id = this.commands.size() - 1;
            this.textLogic.setTextAndCursor(this.commands.get((int)this.id).command);
        }
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        for (int i = 0; i < this.commands.size(); ++i) {
            Entry entry = this.commands.get(i);
            if (entry.command.isEmpty()) {
                this.drawStringTrimmed(graphics, this.gui, (FormattedText)Translator.translatable("hqm.commandEdit.deleted", new Object[0]), 190, 65 + i * 10, 0xFF0000);
                continue;
            }
            this.drawStringTrimmed(graphics, this.gui, Translator.plain(entry.command), 190, this.getLineY(i), entry.edited ? 16729344 : 0);
        }
        if (this.added != null && !this.added.isEmpty()) {
            this.drawStringTrimmed(graphics, this.gui, Translator.plain(this.added), 190, this.getLineY(this.getLineForAdded()), 0x447449);
        }
    }

    @Override
    public void save() {
        this.storeCurrentText();
        if (this.added != null && !this.added.isEmpty()) {
            this.quest.getRewards().addCommand(this.added);
            SaveHelper.add(EditType.COMMAND_ADD);
        }
        for (int i = this.commands.size() - 1; i >= 0; --i) {
            Entry entry = this.commands.get(i);
            if (!entry.edited) continue;
            if (entry.command.isEmpty()) {
                this.quest.getRewards().removeCommand(i);
                SaveHelper.add(EditType.COMMAND_REMOVE);
                continue;
            }
            this.quest.getRewards().editCommand(i, entry.command);
            SaveHelper.add(EditType.COMMAND_CHANGE);
        }
    }

    @Override
    public void drawTooltip(GuiGraphics graphics, int mX, int mY) {
        super.drawTooltip(graphics, mX, mY);
        for (int i = 0; i < this.commands.size(); ++i) {
            if (!this.isOnCommand(i, mX, mY)) continue;
            Entry entry = this.commands.get(i);
            if (entry.command.isEmpty()) {
                this.drawStringTrimmed(graphics, this.gui, (FormattedText)Translator.translatable("hqm.commandEdit.deleted", new Object[0]), 190, this.getLineY(i), 0xF76767);
                continue;
            }
            this.drawStringTrimmed(graphics, this.gui, Translator.plain(entry.command), 190, this.getLineY(i), entry.edited ? 16362362 : 0x969696);
        }
        if (this.added != null && !this.added.isEmpty()) {
            this.drawStringTrimmed(graphics, this.gui, Translator.plain(this.added), 190, this.getLineY(this.getLineForAdded()), 5938016);
        }
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        super.onClick(mX, mY, b);
        for (int i = 0; i < this.commands.size(); ++i) {
            if (!this.isOnCommand(i, mX, mY)) continue;
            this.selectCommand(i);
            return;
        }
        if (this.isOnCommand(this.getLineForAdded(), mX, mY)) {
            this.selectAddedCommand();
        }
    }

    private boolean isOnCommand(int id, int mX, int mY) {
        int minY = this.getLineY(id);
        return 190 < mX && mX < 300 && minY < mY && mY < minY + 10;
    }

    private int getLineY(int line) {
        return 65 + line * 10;
    }

    private int getLineForAdded() {
        return this.commands.size();
    }

    private void selectCommand(int id) {
        if (this.id == id) {
            return;
        }
        this.storeCurrentText();
        this.id = id;
        this.textLogic.setTextAndCursor(this.commands.get((int)id).command);
    }

    private void selectAddedCommand() {
        if (this.id == -1) {
            return;
        }
        this.storeCurrentText();
        this.id = -1;
        this.textLogic.setTextAndCursor(this.added);
    }

    private void storeCurrentText() {
        String command = this.textLogic.getText();
        if (this.id < 0) {
            this.added = command;
        } else if (!this.commands.get((int)this.id).command.equals(command)) {
            this.commands.set(this.id, new Entry(command, true));
        }
    }

    private void drawStringTrimmed(GuiGraphics graphics, GuiBase gui, FormattedText text, int x, int y, int colour) {
        final CharacterLimitingVisitor characterLimitingVisitor = new CharacterLimitingVisitor(25);
        text = text.m_7451_((FormattedText.StyledContentConsumer)new FormattedText.StyledContentConsumer<FormattedText>(){
            private final ComponentCollector collector = new ComponentCollector();

            public Optional<FormattedText> m_7164_(Style style, String string) {
                characterLimitingVisitor.resetLength();
                if (!StringDecomposer.m_14346_((String)string, (Style)style, (FormattedCharSink)characterLimitingVisitor)) {
                    String string2 = string.substring(0, characterLimitingVisitor.getLength());
                    if (!string2.isEmpty()) {
                        this.collector.m_90675_(FormattedText.m_130762_((String)string2, (Style)style));
                    }
                    return Optional.of(this.collector.m_90677_());
                }
                if (!string.isEmpty()) {
                    this.collector.m_90675_(FormattedText.m_130762_((String)string, (Style)style));
                }
                return Optional.empty();
            }
        }, Style.f_131099_).orElse(text);
        gui.drawString(graphics, text, x, y, colour);
    }

    private record Entry(String command, boolean edited) {
    }

    static class CharacterLimitingVisitor
    implements FormattedCharSink {
        private int widthLeft;
        private int length;

        public CharacterLimitingVisitor(int maxWidth) {
            this.widthLeft = maxWidth;
        }

        public boolean m_6411_(int i, Style style, int j) {
            --this.widthLeft;
            if ((float)this.widthLeft >= 0.0f) {
                this.length = i + Character.charCount(j);
                return true;
            }
            return false;
        }

        public int getLength() {
            return this.length;
        }

        public void resetLength() {
            this.length = 0;
        }
    }
}

