/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.client.interfaces.widget.ArrowSelectionHelper;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.client.interfaces.widget.NumberTextBox;
import hardcorequesting.common.forge.client.interfaces.widget.TextBox;
import hardcorequesting.common.forge.quests.task.icon.VisitLocationTask;
import hardcorequesting.common.forge.util.HQMUtil;
import hardcorequesting.common.forge.util.Translator;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.FormattedText;

public class LocationMenu
extends GuiEditMenu {
    private final Consumer<Result> resultConsumer;
    private VisitLocationTask.Visibility visibility;
    private final BlockPos.MutableBlockPos pos;
    private int radius;
    private String dimension;

    public static void display(GuiQuestBook gui, VisitLocationTask.Visibility visibility, BlockPos initPos, int initRadius, String initDimension, Consumer<Result> resultConsumer) {
        gui.setEditMenu(new LocationMenu(gui, visibility, initPos, initRadius, initDimension, resultConsumer));
    }

    private LocationMenu(GuiQuestBook gui, VisitLocationTask.Visibility visibilityIn, BlockPos initPos, int initRadius, String initDimension, Consumer<Result> resultConsumer) {
        super(gui, true);
        this.resultConsumer = resultConsumer;
        this.visibility = visibilityIn;
        this.pos = new BlockPos.MutableBlockPos(initPos.m_123341_(), initPos.m_123342_(), initPos.m_123343_());
        this.radius = initRadius;
        this.dimension = initDimension;
        this.addTextBox(new NumberTextBox((GuiBase)gui, 20, 30, (FormattedText)Translator.translatable("hqm.locationMenu.xTarget", new Object[0]), true, () -> ((BlockPos.MutableBlockPos)this.pos).m_123341_(), arg_0 -> ((BlockPos.MutableBlockPos)this.pos).m_142451_(arg_0)));
        this.addTextBox(new NumberTextBox((GuiBase)gui, 20, 60, (FormattedText)Translator.translatable("hqm.locationMenu.yTarget", new Object[0]), true, () -> ((BlockPos.MutableBlockPos)this.pos).m_123342_(), arg_0 -> ((BlockPos.MutableBlockPos)this.pos).m_142448_(arg_0)));
        this.addTextBox(new NumberTextBox((GuiBase)gui, 20, 90, (FormattedText)Translator.translatable("hqm.locationMenu.zTarget", new Object[0]), true, () -> ((BlockPos.MutableBlockPos)this.pos).m_123343_(), arg_0 -> ((BlockPos.MutableBlockPos)this.pos).m_142443_(arg_0)));
        this.addTextBox(new TextBox(gui, initDimension, 20, 120, true){

            @Override
            public void textChanged() {
                super.textChanged();
                LocationMenu.this.dimension = this.getText();
            }

            @Override
            protected void draw(GuiGraphics graphics, boolean selected, int mX, int mY) {
                super.draw(graphics, selected, mX, mY);
                this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.locationMenu.dim", new Object[0]), this.x, this.y + -10, 0x404040);
            }
        });
        this.addTextBox(new NumberTextBox(gui, 20, 150, (FormattedText)Translator.translatable("hqm.locationMenu.radius", new Object[0]), true, () -> this.radius, value -> {
            this.radius = value;
        }){

            @Override
            protected void draw(GuiGraphics graphics, boolean selected, int mX, int mY) {
                super.draw(graphics, selected, mX, mY);
                this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.locationMenu.negRadius", new Object[0]), 0.7f, 130), this.x, this.y + 30 + -10, 0.7f, 0x404040);
            }
        });
        this.addClickable(new LargeButton(gui, "hqm.locationMenu.location", 100, 20){

            @Override
            public void onClick() {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    LocationMenu.this.pos.m_122169_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                    LocationMenu.this.dimension = player.m_9236_().m_46472_().m_135782_().toString();
                    LocationMenu.this.reloadTextBoxes();
                }
            }
        });
        this.addClickable(new ArrowSelectionHelper(gui, 180, 30){

            @Override
            protected void onArrowClick(boolean left) {
                LocationMenu.this.visibility = left ? (VisitLocationTask.Visibility)HQMUtil.cyclePrev((Enum[])VisitLocationTask.Visibility.values(), (Enum)LocationMenu.this.visibility) : (VisitLocationTask.Visibility)HQMUtil.cycleNext((Enum[])VisitLocationTask.Visibility.values(), (Enum)LocationMenu.this.visibility);
            }

            @Override
            protected FormattedText getArrowText() {
                return LocationMenu.this.visibility.getName();
            }

            @Override
            protected FormattedText getArrowDescription() {
                return LocationMenu.this.visibility.getDescription();
            }
        });
    }

    @Override
    public void save() {
        this.resultConsumer.accept(new Result(this.visibility, this.pos.m_7949_(), this.radius, this.dimension));
    }

    public static class Result {
        private final VisitLocationTask.Visibility visibility;
        private final BlockPos pos;
        private final int radius;
        private final String dimension;

        private Result(VisitLocationTask.Visibility visibility, BlockPos pos, int radius, String dimension) {
            this.visibility = visibility;
            this.pos = pos;
            this.radius = radius;
            this.dimension = dimension;
        }

        public VisitLocationTask.Visibility getVisibility() {
            return this.visibility;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getRadius() {
            return this.radius;
        }

        public String getDimension() {
            return this.dimension;
        }
    }
}

