/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.client.interfaces.widget.ArrowSelectionHelper;
import hardcorequesting.common.forge.client.interfaces.widget.ExtendedScrollBar;
import hardcorequesting.common.forge.client.interfaces.widget.ScrollBar;
import hardcorequesting.common.forge.client.interfaces.widget.TextBox;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;

public class PickAdvancementMenu
extends GuiEditMenu {
    private static final int START_X = 20;
    private static final int START_Y = 20;
    private static final int OFFSET_Y = 8;
    private static final int VISIBLE_MOBS = 24;
    private final Consumer<String> resultConsumer;
    private String advancement;
    private final ExtendedScrollBar<String> scrollBar;
    private final List<String> rawAdvancemenNames;
    private final List<String> advancementNames;

    public static void display(GuiQuestBook gui, String advancement, Consumer<String> resultConsumer) {
        gui.setEditMenu(new PickAdvancementMenu(gui, advancement, resultConsumer));
    }

    private PickAdvancementMenu(GuiQuestBook gui, String advancement, Consumer<String> resultConsumer) {
        super(gui, false);
        this.resultConsumer = resultConsumer;
        this.advancement = advancement;
        this.scrollBar = new ExtendedScrollBar(gui, ScrollBar.Size.LONG, 160, 18, 20, 24, () -> this.advancementNames);
        this.addScrollBar(this.scrollBar);
        this.addTextBox(new TextBox(gui, "", 250, 18, false){

            @Override
            public void textChanged() {
                super.textChanged();
                PickAdvancementMenu.this.updateAdvancements(this.getText());
            }
        });
        this.addClickable(new ArrowSelectionHelper(gui, 180, 70){

            @Override
            protected void onArrowClick(boolean left) {
            }

            @Override
            protected FormattedText getArrowText() {
                return Translator.plain("Exact Advancement");
            }

            @Override
            protected FormattedText getArrowDescription() {
                return Translator.plain("Completing the exact advancement is required.");
            }
        });
        this.rawAdvancemenNames = new ArrayList<String>();
        this.advancementNames = new ArrayList<String>();
        for (Advancement a : HardcoreQuestingCore.getServer().m_129889_().m_136028_()) {
            String adv = a.m_138327_().toString();
            this.rawAdvancemenNames.add(adv);
            this.advancementNames.add(adv);
        }
        Collections.sort(this.advancementNames);
        this.updateAdvancements("");
    }

    private void updateAdvancements(String search) {
        if (this.advancementNames != null) {
            this.advancementNames.clear();
            for (String rawAdv : this.rawAdvancemenNames) {
                if (!rawAdv.toLowerCase().contains(search.toLowerCase())) continue;
                this.advancementNames.add(rawAdv);
            }
            Collections.sort(this.advancementNames);
        }
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int nameY = 20;
        for (String name : this.scrollBar.getVisibleEntries()) {
            boolean selected = name.equals(this.advancement);
            boolean inBounds = this.gui.inBounds(20, nameY, 130, 6, mX, mY);
            this.gui.drawString(graphics, Translator.plain(name), 20, nameY, 0.7f, selected ? (inBounds ? 0xC0C0C0 : 0xA0A0A0) : (inBounds ? 0x707070 : 0x404040));
            nameY += 8;
        }
        this.gui.drawString(graphics, Translator.plain("Search"), 180, 20, 0x404040);
        this.gui.drawString(graphics, Translator.plain((this.advancement == null ? "Nothing" : "Currently") + "Selected"), 180, 40, 0x404040);
        if (this.advancement != null) {
            this.gui.drawString(graphics, Translator.plain(this.advancement), 180, 50, 0.7f, 0x404040);
        }
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        super.onClick(mX, mY, b);
        int nameY = 20;
        for (String name : this.scrollBar.getVisibleEntries()) {
            if (this.gui.inBounds(20, nameY, 130, 6, mX, mY)) {
                if (name.equals(this.advancement)) {
                    this.advancement = null;
                    break;
                }
                this.advancement = name;
                break;
            }
            nameY += 8;
        }
    }

    @Override
    public void save() {
        this.resultConsumer.accept(this.advancement);
    }
}

