/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.client.TextSearch;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.client.interfaces.widget.NumberTextBox;
import hardcorequesting.common.forge.client.interfaces.widget.TextBox;
import hardcorequesting.common.forge.items.ModItems;
import hardcorequesting.common.forge.quests.ItemPrecision;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PickItemMenu<T>
extends GuiEditMenu {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int ARROW_X_LEFT = 20;
    private static final int ARROW_X_RIGHT = 150;
    private static final int ARROW_Y = 40;
    private static final int ARROW_SRC_X = 244;
    private static final int ARROW_SRC_Y = 176;
    private static final int ARROW_W = 6;
    private static final int ARROW_H = 10;
    private static final int PLAYER_X = 20;
    private static final int PLAYER_Y = 80;
    private static final int SEARCH_X = 180;
    private static final int SEARCH_Y = 30;
    private static final int SIZE = 18;
    private static final int OFFSET = 20;
    private static final int ITEMS_PER_LINE = 7;
    private static final int SEARCH_LINES = 9;
    public static final int ITEMS_TO_DISPLAY = 63;
    private static final int PLAYER_LINES = 6;
    private final Consumer<Result<T>> resultConsumer;
    private final boolean precisionInput;
    private final Type<T> type;
    private final List<T> playerItems;
    private List<T> searchItems;
    private T selected;
    private int amount;
    private ItemPrecision precision;
    private boolean clicked;
    private long lastClicked;

    public static <T> void display(GuiQuestBook gui, T initial, Type<T> type, Consumer<Result<T>> resultConsumer) {
        gui.setEditMenu(new PickItemMenu<T>(gui, initial, type, 1, false, ItemPrecision.PRECISE, false, resultConsumer));
    }

    public static <T> void display(GuiQuestBook gui, T obj, Type<T> type, int amount, Consumer<Result<T>> resultConsumer) {
        gui.setEditMenu(new PickItemMenu<T>(gui, obj, type, amount, true, ItemPrecision.PRECISE, false, resultConsumer));
    }

    public static <T> void display(GuiQuestBook gui, T obj, Type<T> type, int amount, ItemPrecision precision, Consumer<Result<T>> resultConsumer) {
        gui.setEditMenu(new PickItemMenu<T>(gui, obj, type, amount, true, precision, true, resultConsumer));
    }

    private PickItemMenu(GuiQuestBook gui, T element, Type<T> type, int amountIn, boolean amountInput, ItemPrecision precision, boolean precisionInput, Consumer<Result<T>> resultConsumer) {
        super(gui, true);
        this.resultConsumer = resultConsumer;
        this.type = type;
        this.precisionInput = precisionInput;
        this.selected = type.copyWith(element, 1);
        this.amount = amountIn;
        this.precision = precision;
        this.searchItems = Collections.emptyList();
        this.playerItems = type.createPlayerEntries((Player)Minecraft.m_91087_().f_91074_);
        if (amountInput) {
            this.addTextBox(new NumberTextBox((GuiBase)gui, 100, 18, FormattedText.f_130760_, () -> this.amount, value -> {
                this.amount = Math.max(1, value);
            }));
        }
        this.addTextBox(new TextBox(gui, "", 230, 18, false){

            @Override
            public void textChanged() {
                super.textChanged();
                String text = this.getText();
                PickItemMenu.this.searchItems = TextSearch.search(text, PickItemMenu.this.type::getSearchEntriesStream, 63);
            }
        });
    }

    private boolean inArrowBounds(GuiBase gui, int mX, int mY, boolean left) {
        return gui.inBounds(left ? 20 : 150, 40, 6, 10, mX, mY);
    }

    private void drawArrow(GuiGraphics graphics, GuiBase gui, int mX, int mY, boolean left) {
        int srcX = 244 + (left ? 0 : 6);
        int srcY = 176 + (this.inArrowBounds(gui, mX, mY, left) ? (this.clicked ? 1 : 2) : 0) * 10;
        gui.drawRect(graphics, GuiBase.MAP_TEXTURE, left ? 20 : 150, 40, srcX, srcY, 6, 10);
    }

    private boolean usePrecision() {
        return this.precisionInput && this.type.mayHavePrecision(this.selected);
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        this.gui.drawString(graphics, Translator.plain("Selected"), 20, 20, 0x404040);
        this.type.draw(this.selected, graphics, this.gui, 70, 15, mX, mY);
        this.gui.drawString(graphics, Translator.plain("Search"), 180, 20, 0x404040);
        this.drawList(graphics, this.gui, 180, 30, this.searchItems, mX, mY);
        this.gui.drawString(graphics, Translator.plain("Player inventory"), 20, 70, 0x404040);
        this.drawList(graphics, this.gui, 20, 80, this.playerItems, mX, mY);
        if (this.usePrecision()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawArrow(graphics, this.gui, mX, mY, true);
            this.drawArrow(graphics, this.gui, mX, mY, false);
            this.gui.drawCenteredString(graphics, Translator.plain(this.precision.getName()), 26, 40, 0.7f, 124, 10, 0x404040);
        }
    }

    @Override
    public void drawTooltip(GuiGraphics graphics, int mX, int mY) {
        super.drawTooltip(graphics, mX, mY);
        this.drawListMouseOver(graphics, this.gui, 180, 30, this.searchItems, mX, mY);
        this.drawListMouseOver(graphics, this.gui, 20, 80, this.playerItems, mX, mY);
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        super.onClick(mX, mY, b);
        if (this.clickList(this.gui, 20, 80, this.playerItems, mX, mY)) {
            return;
        }
        if (this.clickList(this.gui, 180, 30, this.searchItems, mX, mY)) {
            return;
        }
        if (this.usePrecision()) {
            if (this.inArrowBounds(this.gui, mX, mY, true)) {
                ImmutableList<ItemPrecision> precisionTypes = ItemPrecision.getPrecisionTypes();
                this.precision = (ItemPrecision)precisionTypes.get((precisionTypes.indexOf(this.precision) + precisionTypes.size() - 1) % precisionTypes.size());
                this.clicked = true;
            } else if (this.inArrowBounds(this.gui, mX, mY, false)) {
                ImmutableList<ItemPrecision> precisionTypes = ItemPrecision.getPrecisionTypes();
                this.precision = (ItemPrecision)precisionTypes.get((precisionTypes.indexOf(this.precision) + 1) % precisionTypes.size());
                this.clicked = true;
            }
        }
    }

    @Override
    public void onRelease(int mX, int mY, int button) {
        super.onRelease(mX, mY, button);
        this.clicked = false;
    }

    @Override
    public void save() {
        if (!this.type.isEmpty(this.selected)) {
            this.resultConsumer.accept(new Result<T>(this.selected, this.amount, this.precision, this.type));
        }
    }

    private void drawList(GuiGraphics graphics, GuiBase gui, int x, int y, List<T> items, int mX, int mY) {
        for (int i = 0; i < items.size(); ++i) {
            T element = items.get(i);
            int xI = i % 7;
            int yI = i / 7;
            this.type.draw(element, graphics, gui, x + xI * 20, y + yI * 20, mX, mY);
        }
    }

    private void drawListMouseOver(GuiGraphics graphics, GuiBase gui, int x, int y, List<T> items, int mX, int mY) {
        for (int i = 0; i < items.size(); ++i) {
            T element = items.get(i);
            int xI = i % 7;
            int yI = i / 7;
            if (!gui.inBounds(x + xI * 20, y + yI * 20, 18, 18, mX, mY)) continue;
            if (element == null) break;
            gui.renderTooltipL(graphics, this.type.getName(element, gui), mX + gui.getLeft(), mY + gui.getTop());
            break;
        }
    }

    private boolean clickList(GuiBase gui, int x, int y, List<T> items, int mX, int mY) {
        for (int i = 0; i < items.size(); ++i) {
            T element = items.get(i);
            int xI = i % 7;
            int yI = i / 7;
            if (!gui.inBounds(x + xI * 20, y + yI * 20, 18, 18, mX, mY)) continue;
            if (element == null) break;
            this.selected = element;
            long tickCount = Minecraft.m_91087_().f_91073_.m_46467_();
            long lastDiff = tickCount - this.lastClicked;
            if (0L <= lastDiff && lastDiff < 6L && !this.type.isEmpty(this.selected)) {
                this.save();
                this.close();
                return true;
            }
            this.lastClicked = tickCount;
            break;
        }
        return false;
    }

    private static List<ItemStack> getPlayerItems(Player player) {
        ArrayList<ItemStack> playerItems = new ArrayList<ItemStack>();
        Inventory inventory = player.m_150109_();
        int itemLength = inventory.m_6643_();
        for (int i = 0; i < itemLength; ++i) {
            ItemStack invStack = inventory.m_8020_(i);
            if (invStack.m_41619_() || invStack.m_41720_() == ModItems.book.get()) continue;
            ItemStack stack = invStack.m_41777_();
            stack.m_41764_(1);
            if (!playerItems.stream().noneMatch(other -> ItemStack.m_41728_((ItemStack)stack, (ItemStack)other))) continue;
            playerItems.add(stack);
        }
        return playerItems;
    }

    private static List<FluidStack> getPlayerFluids(Player player) {
        ArrayList<FluidStack> playerFluids = new ArrayList<FluidStack>();
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        Inventory inventory = player.m_150109_();
        int itemLength = inventory.m_6643_();
        for (int i = 0; i < itemLength; ++i) {
            ItemStack stack = inventory.m_8020_(i);
            for (FluidStack fluid : HardcoreQuestingCore.platform.findFluidsIn(stack)) {
                if (fluid.isEmpty() || !fluids.add(fluid.getFluid())) continue;
                playerFluids.add(fluid);
            }
        }
        return playerFluids;
    }

    public static abstract class Type<T> {
        public static final Type<ItemStack> ITEM = new Type<ItemStack>(){

            @Override
            protected List<ItemStack> createPlayerEntries(Player player) {
                return PickItemMenu.getPlayerItems(player);
            }

            @Override
            protected Stream<TextSearch.SearchEntry<ItemStack>> getSearchEntriesStream() {
                return TextSearch.ITEMS.stream();
            }

            @Override
            protected void draw(ItemStack item, GuiGraphics graphics, GuiBase gui, int x, int y, int mX, int mY) {
                gui.drawItemStack(graphics, item, x, y, mX, mY, false);
            }

            @Override
            protected List<Component> getName(ItemStack item, GuiBase gui) {
                return Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)item);
            }

            @Override
            protected boolean isEmpty(ItemStack item) {
                return item.m_41619_();
            }

            @Override
            protected boolean mayHavePrecision(ItemStack item) {
                return true;
            }

            @Override
            protected ItemStack copyWith(ItemStack item, int amount) {
                ItemStack newStack = item.m_41777_();
                newStack.m_41764_(Mth.m_14045_((int)amount, (int)1, (int)127));
                return newStack;
            }
        };
        public static final Type<Either<ItemStack, FluidStack>> ITEM_FLUID = new Type<Either<ItemStack, FluidStack>>(){

            @Override
            protected List<Either<ItemStack, FluidStack>> createPlayerEntries(Player player) {
                return Stream.concat(PickItemMenu.getPlayerItems(player).stream().map(Either::left), PickItemMenu.getPlayerFluids(player).stream().map(Either::right)).limit(42L).collect(Collectors.toList());
            }

            @Override
            protected Stream<TextSearch.SearchEntry<Either<ItemStack, FluidStack>>> getSearchEntriesStream() {
                return Stream.concat(TextSearch.innerMap(TextSearch.ITEMS.stream(), Either::left), TextSearch.innerMap(TextSearch.FLUIDS.stream(), Either::right));
            }

            @Override
            protected void draw(Either<ItemStack, FluidStack> item, GuiGraphics graphics, GuiBase gui, int x, int y, int mX, int mY) {
                item.ifLeft(stack -> gui.drawItemStack(graphics, (ItemStack)stack, x, y, mX, mY, false)).ifRight(stack -> gui.drawFluid((FluidStack)stack, graphics, x, y, mX, mY));
            }

            @Override
            protected List<Component> getName(Either<ItemStack, FluidStack> item, GuiBase gui) {
                return (List)item.map(stack -> Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)stack), stack -> Collections.singletonList(stack.getName()));
            }

            @Override
            protected boolean isEmpty(Either<ItemStack, FluidStack> item) {
                return (Boolean)item.map(ItemStack::m_41619_, FluidStack::isEmpty);
            }

            @Override
            protected boolean mayHavePrecision(Either<ItemStack, FluidStack> item) {
                return item.left().isPresent();
            }

            @Override
            protected Either<ItemStack, FluidStack> copyWith(Either<ItemStack, FluidStack> item, int amount) {
                return item.mapBoth(stack -> {
                    ItemStack newStack = stack.m_41777_();
                    newStack.m_41764_(amount);
                    return newStack;
                }, stack -> FluidStack.create((Fluid)stack.getFluid(), (long)amount));
            }
        };

        protected abstract List<T> createPlayerEntries(Player var1);

        protected abstract Stream<TextSearch.SearchEntry<T>> getSearchEntriesStream();

        protected abstract void draw(T var1, GuiGraphics var2, GuiBase var3, int var4, int var5, int var6, int var7);

        protected abstract List<? extends FormattedText> getName(T var1, GuiBase var2);

        protected abstract boolean isEmpty(T var1);

        protected abstract boolean mayHavePrecision(T var1);

        protected abstract T copyWith(T var1, int var2);
    }

    public static class Result<T> {
        private final T value;
        private final int amount;
        private final ItemPrecision precision;
        private final Type<T> type;

        private Result(T value, int amount, ItemPrecision precision, Type<T> type) {
            this.value = value;
            this.amount = amount;
            this.precision = precision;
            this.type = type;
        }

        public T get() {
            return this.type.copyWith(this.value, 1);
        }

        public T getWithAmount() {
            return this.type.copyWith(this.value, this.amount);
        }

        public int getAmount() {
            return this.amount;
        }

        public ItemPrecision getPrecision() {
            return this.precision;
        }
    }
}

