/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.client.interfaces.widget.ArrowSelectionHelper;
import hardcorequesting.common.forge.client.interfaces.widget.ExtendedScrollBar;
import hardcorequesting.common.forge.client.interfaces.widget.NumberTextBox;
import hardcorequesting.common.forge.client.interfaces.widget.ScrollBar;
import hardcorequesting.common.forge.client.interfaces.widget.TextBox;
import hardcorequesting.common.forge.quests.task.icon.TameMobsTask;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class PickMobMenu
extends GuiEditMenu {
    public static final List<Entry> EXTRA_TAME_ENTRIES = ImmutableList.of((Object)new Entry(TameMobsTask.ABSTRACT_HORSE, Translator.plain("Any Horse-like Entity")));
    private static final int START_X = 20;
    private static final int START_Y = 20;
    private static final int OFFSET_Y = 8;
    private static final int VISIBLE_MOBS = 24;
    private final Consumer<Result> resultConsumer;
    private final String textKey;
    private Entry mob;
    private int amount;
    private final ExtendedScrollBar<Entry> scrollBar;
    private final List<Entry> rawMobs;
    private final List<Entry> mobs;

    public static void display(GuiQuestBook gui, ResourceLocation initMobId, int initAmount, String textKey, Consumer<Result> resultConsumer) {
        gui.setEditMenu(new PickMobMenu(gui, initMobId, initAmount, textKey, Collections.emptyList(), resultConsumer));
    }

    public static void display(GuiQuestBook gui, ResourceLocation initMobId, int initAmount, String textKey, List<Entry> extraEntries, Consumer<Result> resultConsumer) {
        gui.setEditMenu(new PickMobMenu(gui, initMobId, initAmount, textKey, extraEntries, resultConsumer));
    }

    private PickMobMenu(GuiQuestBook gui, ResourceLocation initMobId, int initAmount, final String textKey, List<Entry> extraEntries, Consumer<Result> resultConsumer) {
        super(gui, false);
        this.resultConsumer = resultConsumer;
        this.textKey = textKey;
        this.amount = initAmount;
        this.scrollBar = new ExtendedScrollBar(gui, ScrollBar.Size.LONG, 160, 18, 20, 24, () -> this.mobs);
        this.addScrollBar(this.scrollBar);
        this.addTextBox(new NumberTextBox((GuiBase)gui, 180, 150, (FormattedText)Translator.translatable("hqm." + textKey + ".reqKills", new Object[0]), () -> this.amount, value -> {
            this.amount = value;
        }));
        this.addTextBox(new TextBox(gui, "", 250, 18, false){

            @Override
            public void textChanged() {
                super.textChanged();
                PickMobMenu.this.updateMobs(this.getText());
            }
        });
        this.addClickable(new ArrowSelectionHelper(gui, 180, 70){

            @Override
            protected boolean isArrowVisible() {
                return false;
            }

            @Override
            protected void onArrowClick(boolean left) {
            }

            @Override
            protected FormattedText getArrowText() {
                return Translator.translatable("hqm." + textKey + ".typeMatch.title", new Object[0]);
            }

            @Override
            protected FormattedText getArrowDescription() {
                return Translator.translatable("hqm." + textKey + ".typeMatch.desc", new Object[0]);
            }
        });
        this.rawMobs = new ArrayList<Entry>();
        this.mobs = new ArrayList<Entry>();
        for (EntityType type : BuiltInRegistries.f_256780_) {
            if (!type.m_20654_()) continue;
            this.rawMobs.add(new Entry(type));
        }
        this.rawMobs.addAll(extraEntries);
        for (Entry entry2 : this.rawMobs) {
            if (!entry2.id.equals((Object)initMobId)) continue;
            this.mob = entry2;
        }
        this.rawMobs.sort(Comparator.comparing(entry -> entry.id));
        this.updateMobs("");
    }

    private void updateMobs(String search) {
        search = search.toLowerCase();
        if (this.mobs != null) {
            this.mobs.clear();
            for (Entry rawMob : this.rawMobs) {
                if (!rawMob.description.toString().toLowerCase().contains(search) && !rawMob.id.toString().toLowerCase().contains(search)) continue;
                this.mobs.add(rawMob);
            }
        }
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int mobY = 20;
        for (Entry entry : this.scrollBar.getVisibleEntries()) {
            boolean selected = entry.equals(this.mob);
            boolean inBounds = this.gui.inBounds(20, mobY, 130, 6, mX, mY);
            this.gui.drawString(graphics, entry.description, 20, mobY, 0.7f, selected ? (inBounds ? 0xC0C0C0 : 0xA0A0A0) : (inBounds ? 0x707070 : 0x404040));
            mobY += 8;
        }
        this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm." + this.textKey + ".search", new Object[0]), 180, 20, 0x404040);
        this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm." + this.textKey + "." + (this.mob == null ? "nothing" : "currently") + "Selected", new Object[0]), 180, 40, 0x404040);
        if (this.mob != null) {
            this.gui.drawString(graphics, this.mob.description, 180, 50, 0.7f, 0x404040);
        }
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        super.onClick(mX, mY, b);
        int mobY = 20;
        for (Entry entry : this.scrollBar.getVisibleEntries()) {
            if (this.gui.inBounds(20, mobY, 130, 6, mX, mY)) {
                if (entry.equals(this.mob)) {
                    this.mob = null;
                    break;
                }
                this.mob = entry;
                break;
            }
            mobY += 8;
        }
    }

    @Override
    public void save() {
        this.resultConsumer.accept(new Result(this.mob.id, Math.max(1, this.amount)));
    }

    public static class Entry {
        private final ResourceLocation id;
        private final FormattedText description;

        private Entry(EntityType<?> type) {
            this.id = BuiltInRegistries.f_256780_.m_7981_(type);
            this.description = type.m_20676_();
        }

        public Entry(ResourceLocation id, FormattedText description) {
            this.id = id;
            this.description = description;
        }
    }

    public static class Result {
        private final ResourceLocation mobId;
        private final int amount;

        private Result(ResourceLocation mobId, int amount) {
            this.mobId = mobId;
            this.amount = amount;
        }

        public ResourceLocation getMobId() {
            return this.mobId;
        }

        public int getAmount() {
            return this.amount;
        }
    }
}

