/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.client.interfaces.widget.ExtendedScrollBar;
import hardcorequesting.common.forge.client.interfaces.widget.ScrollBar;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.util.Translator;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PickReputationMenu
extends GuiEditMenu {
    private final Consumer<Reputation> resultConsumer;
    private Reputation selectedReputation;
    private final ExtendedScrollBar<Reputation> scrollBar;

    public static void display(GuiQuestBook gui, Consumer<Reputation> resultConsumer) {
        PickReputationMenu.display(gui, null, resultConsumer);
    }

    public static void display(GuiQuestBook gui, Reputation reputation, Consumer<Reputation> resultConsumer) {
        gui.setEditMenu(new PickReputationMenu(gui, reputation, resultConsumer));
    }

    private PickReputationMenu(GuiQuestBook gui, Reputation reputation, Consumer<Reputation> resultConsumer) {
        super(gui, false);
        this.resultConsumer = resultConsumer;
        this.selectedReputation = reputation;
        this.scrollBar = new ExtendedScrollBar(gui, ScrollBar.Size.LONG, 160, 23, 20, 10, () -> ReputationManager.getInstance().getReputationList());
        this.addScrollBar(this.scrollBar);
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        int x = 20;
        int y = 20;
        for (Reputation reputation : this.scrollBar.getVisibleEntries()) {
            MutableComponent str = reputation.getName();
            boolean hover = this.gui.inBounds(x, y, this.gui.getStringWidth((FormattedText)str), 9, mX, mY);
            boolean selected = reputation.equals(this.selectedReputation);
            this.gui.drawString(graphics, (FormattedText)str, x, y, selected ? (hover ? 0x40CC40 : 0x409040) : (hover ? 0xAAAAAA : 0x404040));
            y += 20;
        }
        this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.rep.select", new Object[0]), 1.0f, 120), 180, 20, 1.0f, 0x404040);
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        super.onClick(mX, mY, b);
        int x = 20;
        int y = 20;
        for (Reputation reputation : this.scrollBar.getVisibleEntries()) {
            MutableComponent str = reputation.getName();
            if (this.gui.inBounds(x, y, this.gui.getStringWidth((FormattedText)str), 9, mX, mY)) {
                this.selectedReputation = reputation;
            }
            y += 20;
        }
    }

    @Override
    public void save() {
        if (this.selectedReputation != null) {
            this.resultConsumer.accept(this.selectedReputation);
        }
    }
}

