/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.client.interfaces.widget.ArrowSelectionHelper;
import hardcorequesting.common.forge.client.interfaces.widget.NumberTextBox;
import hardcorequesting.common.forge.quests.TriggerType;
import hardcorequesting.common.forge.util.HQMUtil;
import hardcorequesting.common.forge.util.Translator;
import java.util.function.Consumer;
import net.minecraft.network.chat.FormattedText;

public class PickTriggerMenu
extends GuiEditMenu {
    private final Consumer<Result> resultConsumer;
    private TriggerType type;
    private int count;

    public static void display(GuiQuestBook gui, TriggerType typeIn, int countIn, Consumer<Result> resultConsumer) {
        gui.setEditMenu(new PickTriggerMenu(gui, typeIn, countIn, resultConsumer));
    }

    private PickTriggerMenu(GuiQuestBook gui, TriggerType typeIn, int countIn, Consumer<Result> resultConsumer) {
        super(gui, true);
        this.resultConsumer = resultConsumer;
        this.type = typeIn;
        this.count = countIn;
        this.addTextBox(new NumberTextBox(gui, 25, 135, (FormattedText)Translator.translatable("hqm.menuTrigger.taskCount", new Object[0]), () -> this.count, value -> {
            this.count = value;
        }){

            @Override
            protected boolean isVisible() {
                return PickTriggerMenu.this.type.isUseTaskCount();
            }
        });
        this.addClickable(new ArrowSelectionHelper(gui, 25, 20){

            @Override
            protected void onArrowClick(boolean left) {
                PickTriggerMenu.this.type = left ? (TriggerType)HQMUtil.cyclePrev((Enum[])TriggerType.values(), (Enum)PickTriggerMenu.this.type) : (TriggerType)HQMUtil.cycleNext((Enum[])TriggerType.values(), (Enum)PickTriggerMenu.this.type);
            }

            @Override
            protected FormattedText getArrowText() {
                return PickTriggerMenu.this.type.getName();
            }

            @Override
            protected FormattedText getArrowDescription() {
                return PickTriggerMenu.this.type.getDescription();
            }
        });
    }

    @Override
    public void save() {
        this.resultConsumer.accept(new Result(this.type, this.count));
    }

    public record Result(TriggerType type, int count) {
    }
}

