/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.client.interfaces.widget.ArrowSelectionHelper;
import hardcorequesting.common.forge.client.interfaces.widget.NumberTextBox;
import hardcorequesting.common.forge.quests.RepeatInfo;
import hardcorequesting.common.forge.quests.RepeatType;
import hardcorequesting.common.forge.util.HQMUtil;
import hardcorequesting.common.forge.util.Translator;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;

public class RepeatInfoMenu
extends GuiEditMenu {
    private final Consumer<RepeatInfo> resultConsumer;
    private RepeatType type;
    private int days;
    private int hours;

    public static void display(GuiQuestBook gui, RepeatInfo info, Consumer<RepeatInfo> resultConsumer) {
        gui.setEditMenu(new RepeatInfoMenu(gui, info, resultConsumer));
    }

    private RepeatInfoMenu(GuiQuestBook gui, RepeatInfo info, Consumer<RepeatInfo> resultConsumer) {
        super(gui, true);
        this.resultConsumer = resultConsumer;
        this.type = info.getType();
        this.days = info.getDays();
        this.hours = info.getHours();
        this.addTextBox(new TextBoxHidden(gui, 25, 100, (FormattedText)Translator.translatable("hqm.repeatMenu.days", new Object[0]), () -> this.days, value -> {
            this.days = value;
        }));
        this.addTextBox(new TextBoxHidden(gui, 25, 130, (FormattedText)Translator.translatable("hqm.repeatMenu.hours", new Object[0]), () -> this.hours, value -> {
            this.hours = value;
        }){

            @Override
            protected void draw(GuiGraphics graphics, boolean selected, int mX, int mY) {
                super.draw(graphics, selected, mX, mY);
                this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.repeatMenu.mcDaysHours", new Object[0]), 0.7f, 150), this.x, this.y + 30 + -10, 0.7f, 0x404040);
            }
        });
        this.addClickable(new ArrowSelectionHelper(gui, 25, 20){

            @Override
            protected void onArrowClick(boolean left) {
                RepeatInfoMenu.this.type = left ? (RepeatType)HQMUtil.cyclePrev((Enum[])RepeatType.values(), (Enum)RepeatInfoMenu.this.type) : (RepeatType)HQMUtil.cycleNext((Enum[])RepeatType.values(), (Enum)RepeatInfoMenu.this.type);
            }

            @Override
            protected FormattedText getArrowText() {
                return RepeatInfoMenu.this.type.getName();
            }

            @Override
            protected FormattedText getArrowDescription() {
                return RepeatInfoMenu.this.type.getDescription();
            }
        });
    }

    @Override
    public void save() {
        this.resultConsumer.accept(new RepeatInfo(this.type, this.days, this.hours));
    }

    private class TextBoxHidden
    extends NumberTextBox {
        public TextBoxHidden(GuiQuestBook gui, int x, int y, FormattedText title, IntSupplier getter, IntConsumer setter) {
            super((GuiBase)gui, x, y, title, getter, setter);
        }

        @Override
        protected boolean isVisible() {
            return RepeatInfoMenu.this.type.isUseTime();
        }
    }
}

