/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.client.interfaces.widget.ArrowSelectionHelper;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.client.interfaces.widget.NumberTextBox;
import hardcorequesting.common.forge.quests.reward.ReputationReward;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;

public class ReputationRewardMenu
extends GuiEditMenu {
    private static final int START_X = 20;
    private static final int START_Y = 50;
    private static final int ERROR_Y = 20;
    private static final int OFFSET = 15;
    private final Consumer<List<ReputationReward>> resultConsumer;
    private final List<ReputationReward> rewards;
    private ReputationReward selectedReward;
    private List<FormattedText> error;
    private final NumberTextBox valueTextBox;

    public static void display(GuiQuestBook gui, List<ReputationReward> rewards, Consumer<List<ReputationReward>> resultConsumer) {
        gui.setEditMenu(new ReputationRewardMenu(gui, rewards, resultConsumer));
    }

    private ReputationRewardMenu(GuiQuestBook gui, List<ReputationReward> rewards, Consumer<List<ReputationReward>> resultConsumer) {
        super(gui, true);
        this.resultConsumer = resultConsumer;
        this.rewards = new ArrayList<ReputationReward>();
        if (rewards != null) {
            for (ReputationReward reward : rewards) {
                this.rewards.add(new ReputationReward((Reputation)reward.getReward(), reward.getValue()));
            }
        }
        this.valueTextBox = new NumberTextBox(gui, 185, 55, (FormattedText)Translator.translatable("hqm.repReward.value", new Object[0]), true, () -> this.selectedReward.getValue(), value -> this.selectedReward.setValue(value)){

            @Override
            protected boolean isVisible() {
                return ReputationRewardMenu.this.selectedReward != null;
            }
        };
        this.addTextBox(this.valueTextBox);
        this.addClickable(new LargeButton(gui, "hqm.repReward.create", 20, 20){

            @Override
            public boolean isVisible() {
                return ReputationRewardMenu.this.isValid();
            }

            @Override
            public void onClick() {
                ReputationRewardMenu.this.rewards.add(new ReputationReward(ReputationManager.getInstance().getReputationList().get(0), 0));
            }
        });
        this.addClickable(new LargeButton(gui, "hqm.repReward.delete", 80, 20){

            @Override
            public boolean isVisible() {
                return ReputationRewardMenu.this.isValid() && ReputationRewardMenu.this.selectedReward != null;
            }

            @Override
            public void onClick() {
                ReputationRewardMenu.this.rewards.remove(ReputationRewardMenu.this.selectedReward);
                ReputationRewardMenu.this.selectedReward = null;
            }
        });
        this.addClickable(new ArrowSelectionHelper(gui, 185, 25){

            @Override
            protected boolean isArrowVisible() {
                return ReputationRewardMenu.this.isValid() && ReputationRewardMenu.this.selectedReward != null;
            }

            @Override
            protected void onArrowClick(boolean left) {
                if (ReputationRewardMenu.this.selectedReward != null && ReputationRewardMenu.this.selectedReward.getReward() != null) {
                    ReputationManager reputationManager = ReputationManager.getInstance();
                    for (int i = 0; i < reputationManager.getReputationList().size(); ++i) {
                        if (!reputationManager.getReputationList().get(i).equals(ReputationRewardMenu.this.selectedReward.getReward())) continue;
                        int id = i + (left ? -1 : 1);
                        if (id < 0) {
                            id = reputationManager.getReputationList().size() - 1;
                        } else if (id >= reputationManager.getReputationList().size()) {
                            id = 0;
                        }
                        ReputationRewardMenu.this.selectedReward.setReward(reputationManager.getReputationList().get(id));
                        break;
                    }
                }
            }

            @Override
            protected FormattedText getArrowText() {
                return ((Reputation)ReputationRewardMenu.this.selectedReward.getReward()).getName();
            }
        });
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        if (this.isValid()) {
            for (int i = 0; i < this.rewards.size(); ++i) {
                FormattedText str = this.rewards.get(i).getLabel();
                boolean hover = this.gui.inBounds(20, 50 + i * 15, this.gui.getStringWidth(str), 9, mX, mY);
                boolean selected = this.rewards.get(i).equals(this.selectedReward);
                this.gui.drawString(graphics, str, 20, 50 + i * 15, selected ? (hover ? 0x40CC40 : 0x409040) : (hover ? 0xAAAAAA : 0x404040));
            }
        } else {
            if (this.error == null) {
                this.error = this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.repReward.noValidReps", new Object[0]), 0.7f, 140);
            }
            this.gui.drawString(graphics, this.error, 20, 20, 0.7f, 0x404040);
        }
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        super.onClick(mX, mY, b);
        if (this.isValid()) {
            for (int i = 0; i < this.rewards.size(); ++i) {
                if (!this.gui.inBounds(20, 50 + i * 15, this.gui.getStringWidth(this.rewards.get(i).getLabel()), 9, mX, mY)) continue;
                if (this.rewards.get(i).equals(this.selectedReward)) {
                    this.selectedReward = null;
                    break;
                }
                this.selectedReward = this.rewards.get(i);
                this.valueTextBox.reloadText();
                break;
            }
        }
    }

    private boolean isValid() {
        return !ReputationManager.getInstance().getReputationList().isEmpty();
    }

    @Override
    public void save() {
        this.resultConsumer.accept(this.rewards);
    }
}

