/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.client.interfaces.widget.AbstractCheckBox;
import hardcorequesting.common.forge.client.interfaces.widget.ArrowSelectionHelper;
import hardcorequesting.common.forge.quests.task.reputation.ReputationTask;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.reputation.ReputationMarker;
import hardcorequesting.common.forge.util.Translator;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ReputationTaskPartMenu
extends GuiEditMenu {
    private static final int BARS_X = 20;
    private static final int LOWER_Y = 50;
    private static final int UPPER_Y = 90;
    private static final int RESULT_Y = 150;
    private static final int BAR_OFFSET_Y = 10;
    private final Consumer<ReputationTask.Part> resultConsumer;
    private final UUID playerId;
    private Reputation reputation = null;
    private int reputationId = -1;
    private ReputationMarker lower;
    private ReputationMarker upper;
    private boolean inverted;

    public static void display(GuiQuestBook gui, UUID playerId, ReputationTask.Part setting, Consumer<ReputationTask.Part> resultConsumer) {
        gui.setEditMenu(new ReputationTaskPartMenu(gui, playerId, setting, resultConsumer));
    }

    private ReputationTaskPartMenu(GuiQuestBook gui, UUID playerId, ReputationTask.Part setting, Consumer<ReputationTask.Part> resultConsumer) {
        super(gui, true);
        this.resultConsumer = resultConsumer;
        this.playerId = playerId;
        ReputationManager reputationManager = ReputationManager.getInstance();
        if (setting.getReputation() == null) {
            this.setReputation(0);
        } else {
            int id = reputationManager.getReputationList().indexOf(this.reputation);
            if (this.reputationId != -1) {
                this.setReputation(id);
                this.lower = setting.getLower();
                this.upper = setting.getUpper();
            } else {
                this.setReputation(0);
            }
            this.inverted = setting.isInverted();
        }
        this.addClickable(new AbstractCheckBox(gui, (FormattedText)Translator.translatable("hqm.repSetting.invRange", new Object[0]), 21, 124){

            @Override
            protected boolean isVisible() {
                return ReputationTaskPartMenu.this.reputation != null;
            }

            @Override
            public boolean getValue() {
                return ReputationTaskPartMenu.this.inverted;
            }

            @Override
            public void setValue(boolean val) {
                ReputationTaskPartMenu.this.inverted = val;
            }
        });
        this.addClickable(new ArrowSelectionHelper(gui, 25, 25){

            @Override
            protected void onArrowClick(boolean left) {
                if (ReputationTaskPartMenu.this.reputationId != -1) {
                    ReputationTaskPartMenu.this.setReputation(ReputationTaskPartMenu.this.reputationId + (left ? -1 : 1));
                }
            }

            @Override
            protected FormattedText getArrowText() {
                if (ReputationManager.getInstance().getReputations().isEmpty()) {
                    return Translator.translatable("hqm.repSetting.invalid", new Object[0]);
                }
                return ReputationTaskPartMenu.this.reputation != null ? ReputationTaskPartMenu.this.reputation.getName() : Translator.translatable("hqm.repSetting.invalid", new Object[0]);
            }

            @Override
            protected FormattedText getArrowDescription() {
                if (ReputationManager.getInstance().getReputations().isEmpty()) {
                    return Translator.translatable("hqm.repReward.noValidReps", new Object[0]);
                }
                return null;
            }
        });
    }

    private void setReputation(int reputationId) {
        List<Reputation> reputations = ReputationManager.getInstance().getReputationList();
        if (!reputations.isEmpty()) {
            this.reputationId = reputationId < 0 ? reputations.size() - 1 : (reputationId >= reputations.size() ? 0 : reputationId);
            this.reputation = reputations.get(this.reputationId);
            this.lower = null;
            this.upper = null;
        }
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        if (this.reputation != null) {
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.repSetting.lower", new Object[0]), 20, 50, 0x404040);
            this.gui.applyColor(-1);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            FormattedText info = this.reputation.drawAndGetTooltip(graphics, this.gui, 20, 60, mX, mY, null, this.playerId, false, null, null, false, this.lower, (FormattedText)(this.lower == null ? FormattedText.f_130760_ : Translator.text("Selected: ").m_7220_((Component)this.lower.getLabel())), false);
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.repSetting.upper", new Object[0]), 20, 90, 0x404040);
            this.gui.applyColor(-1);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            info = this.reputation.drawAndGetTooltip(graphics, this.gui, 20, 100, mX, mY, info, this.playerId, false, null, null, false, this.upper, (FormattedText)(this.upper == null ? FormattedText.f_130760_ : Translator.text("Selected: ").m_7220_((Component)this.upper.getLabel())), false);
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.repSetting.preview", new Object[0]), 20, 150, 0x404040);
            this.gui.applyColor(-1);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            info = this.reputation.drawAndGetTooltip(graphics, this.gui, 20, 160, mX, mY, info, this.playerId, true, this.lower, this.upper, this.inverted, null, null, false);
            if (info != null) {
                this.gui.renderTooltip(graphics, info, mX + this.gui.getLeft(), mY + this.gui.getTop());
            }
        }
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        super.onClick(mX, mY, b);
        if (this.reputation != null) {
            ReputationMarker marker = this.reputation.onActiveClick(this.gui, 20, 60, mX, mY);
            if (marker != null) {
                this.lower = marker.equals(this.lower) ? null : marker;
            } else {
                marker = this.reputation.onActiveClick(this.gui, 20, 100, mX, mY);
                if (marker != null) {
                    this.upper = marker.equals(this.upper) ? null : marker;
                }
            }
        }
    }

    @Override
    public void save() {
        if (this.reputation != null) {
            this.resultConsumer.accept(new ReputationTask.Part(this.reputation, this.lower, this.upper, this.inverted));
        }
    }
}

