/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.client.interfaces.widget.ArrowSelectionHelper;
import hardcorequesting.common.forge.client.interfaces.widget.NumberTextBox;
import hardcorequesting.common.forge.util.Translator;
import java.util.function.IntConsumer;
import net.minecraft.network.chat.FormattedText;

public class RequiredParentCountMenu
extends GuiEditMenu {
    private final IntConsumer resultConsumer;
    private boolean requiresSpecified;
    private int requiredParents;

    public static void display(GuiQuestBook gui, boolean requiresSpecified, int requiredParents, IntConsumer resultConsumer) {
        gui.setEditMenu(new RequiredParentCountMenu(gui, requiresSpecified, requiredParents, resultConsumer));
    }

    private RequiredParentCountMenu(GuiQuestBook gui, boolean requiresSpecified, int requiredParents, IntConsumer resultConsumer) {
        super(gui, true);
        this.resultConsumer = resultConsumer;
        this.requiredParents = requiredParents;
        this.requiresSpecified = requiresSpecified;
        this.addTextBox(new NumberTextBox(gui, 25, 105, (FormattedText)Translator.translatable("hqm.parentCount.count", new Object[0]), () -> this.requiredParents, value -> {
            this.requiredParents = value;
        }){

            @Override
            protected boolean isVisible() {
                return RequiredParentCountMenu.this.requiresSpecified;
            }
        });
        this.addClickable(new ArrowSelectionHelper(gui, 25, 20){

            @Override
            protected void onArrowClick(boolean left) {
                RequiredParentCountMenu.this.requiresSpecified = !RequiredParentCountMenu.this.requiresSpecified;
            }

            @Override
            protected FormattedText getArrowText() {
                return Translator.translatable("hqm.parentCount.req" + (RequiredParentCountMenu.this.requiresSpecified ? "Count" : "All") + ".title", new Object[0]);
            }

            @Override
            protected FormattedText getArrowDescription() {
                return Translator.translatable("hqm.parentCount.req" + (RequiredParentCountMenu.this.requiresSpecified ? "Count" : "All") + ".desc", new Object[0]);
            }
        });
    }

    @Override
    public void save() {
        this.resultConsumer.accept(this.requiresSpecified ? this.requiredParents : -1);
    }
}

