/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.AbstractTextMenu;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import java.util.function.Consumer;
import net.minecraft.client.resources.language.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextMenu
extends AbstractTextMenu {
    private final Consumer<String> resultConsumer;
    private final int limit;
    private final boolean isName;

    public static void display(GuiQuestBook gui, String txt, boolean isName, Consumer<String> resultConsumer) {
        gui.setEditMenu(new TextMenu(gui, txt, isName, -1, resultConsumer));
    }

    public static void display(GuiQuestBook gui, String txt, int limit, Consumer<String> resultConsumer) {
        gui.setEditMenu(new TextMenu(gui, txt, true, limit, resultConsumer));
    }

    private TextMenu(GuiQuestBook gui, String txt, boolean isName, int limit, Consumer<String> resultConsumer) {
        super(gui, txt, !isName);
        this.resultConsumer = resultConsumer;
        this.limit = limit;
        this.isName = isName;
    }

    @Override
    public void save() {
        String str = this.textLogic.getText();
        if (str == null || str.isEmpty()) {
            str = I18n.m_118938_((String)"hqm.textEditor.unnamed", (Object[])new Object[0]);
        }
        if (this.limit >= 0) {
            while (this.gui.getStringWidth(str) > this.limit) {
                str = str.substring(0, str.length() - 1);
            }
        }
        this.resultConsumer.accept(str);
        if (this.isName) {
            SaveHelper.add(EditType.NAME_CHANGE);
        } else {
            SaveHelper.add(EditType.DESCRIPTION_CHANGE);
        }
    }
}

