/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.edit;

import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.AbstractTextMenu;
import hardcorequesting.common.forge.client.interfaces.widget.AbstractCheckBox;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import hardcorequesting.common.forge.util.WrappedText;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class WrappedTextMenu
extends AbstractTextMenu {
    private final Consumer<Optional<WrappedText>> resultConsumer;
    private final int limit;
    private final boolean isName;
    private boolean isTranslated;
    @Nullable
    private List<FormattedText> translatedLines;
    @Nullable
    private String translatedText;

    public static void display(GuiQuestBook gui, WrappedText text, boolean isName, Consumer<WrappedText> resultConsumer) {
        gui.setEditMenu(new WrappedTextMenu(gui, text, isName, -1, WrappedTextMenu.unnamedDefault(resultConsumer)));
    }

    public static void displayWithOptionalResult(GuiQuestBook gui, WrappedText text, boolean isName, Consumer<Optional<WrappedText>> resultConsumer) {
        gui.setEditMenu(new WrappedTextMenu(gui, text, isName, -1, resultConsumer));
    }

    public static void display(GuiQuestBook gui, WrappedText text, int limit, Consumer<WrappedText> resultConsumer) {
        gui.setEditMenu(new WrappedTextMenu(gui, text, true, limit, WrappedTextMenu.unnamedDefault(resultConsumer)));
    }

    private static Consumer<Optional<WrappedText>> unnamedDefault(Consumer<WrappedText> consumer) {
        return optional -> consumer.accept(optional.orElseGet(() -> WrappedText.create(I18n.m_118938_((String)"hqm.textEditor.unnamed", (Object[])new Object[0]))));
    }

    private WrappedTextMenu(GuiQuestBook gui, WrappedText text, boolean isName, int limit, Consumer<Optional<WrappedText>> resultConsumer) {
        super(gui, text.getRawText(), !isName);
        this.resultConsumer = resultConsumer;
        this.limit = limit;
        this.isName = isName;
        this.isTranslated = text.shouldTranslate();
        this.addClickable(new AbstractCheckBox(gui, (FormattedText)Translator.translatable("hqm.textEditor.translationKey", new Object[0]), 180, 20){

            @Override
            public boolean getValue() {
                return WrappedTextMenu.this.isTranslated;
            }

            @Override
            public void setValue(boolean val) {
                WrappedTextMenu.this.isTranslated = val;
                WrappedTextMenu.this.onTextChanged(WrappedTextMenu.this.textLogic.getText());
            }
        });
        this.addClickable(new LargeButton(gui, "hqm.textEditor.asRawText", 180, 40){

            @Override
            public boolean isEnabled() {
                return WrappedTextMenu.this.translatedText != null;
            }

            @Override
            public boolean isVisible() {
                return WrappedTextMenu.this.isTranslated;
            }

            @Override
            public void onClick() {
                WrappedTextMenu.this.setRawTextFromTranslation();
            }
        });
        this.textLogic.setListener(this::onTextChanged);
        this.onTextChanged(this.textLogic.getText());
    }

    private void onTextChanged(String text) {
        if (this.isTranslated && !I18n.m_118936_((String)text)) {
            this.textLogic.setTextColor(0xAA0000);
        } else {
            this.textLogic.setTextColor(0x404040);
        }
        if (this.isTranslated && I18n.m_118936_((String)text)) {
            this.translatedText = Objects.requireNonNull(I18n.m_118938_((String)text, (Object[])new Object[0]));
            this.translatedLines = this.gui.getFont().m_92865_().m_92432_(this.translatedText, 140, Style.f_131099_);
        } else {
            this.translatedText = null;
            this.translatedLines = null;
        }
    }

    private void setRawTextFromTranslation() {
        this.isTranslated = false;
        this.textLogic.setTextAndCursor(this.translatedText);
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        if (this.translatedLines != null) {
            this.gui.drawString(graphics, this.translatedLines, 20, 100, 1.0f, 0x404040);
        }
    }

    @Override
    public void save() {
        String text = this.textLogic.getText();
        if (this.limit >= 0) {
            while (this.gui.getStringWidth(text) > this.limit) {
                text = text.substring(0, text.length() - 1);
            }
        }
        if (text.isEmpty()) {
            this.resultConsumer.accept(Optional.empty());
        } else {
            this.resultConsumer.accept(Optional.of(this.isTranslated ? WrappedText.createTranslated(text) : WrappedText.create(text)));
        }
        if (this.isName) {
            SaveHelper.add(EditType.NAME_CHANGE);
        } else {
            SaveHelper.add(EditType.DESCRIPTION_CHANGE);
        }
    }
}

