/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic;

import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.graphic.Graphic;
import hardcorequesting.common.forge.client.interfaces.widget.ExtendedScrollBar;
import hardcorequesting.common.forge.client.interfaces.widget.ScrollBar;
import hardcorequesting.common.forge.death.DeathStat;
import hardcorequesting.common.forge.death.DeathStatsManager;
import hardcorequesting.common.forge.death.DeathType;
import hardcorequesting.common.forge.util.Translator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DeathStatsGraphic
extends Graphic {
    private static final int PLAYER_INFO_X = 180;
    private static final int PLAYER_INFO_Y = 20;
    private static final int PLAYER_TOTAL_DEATHS_Y = 12;
    private static final int BACKGROUND_SIZE = 22;
    private static final int ICON_OFFSET = 1;
    private static final int BACKGROUND_SRC_X = 234;
    private static final int BACKGROUND_SRC_Y = 55;
    private static final int ICON_SRC_X = 179;
    private static final int ICON_SRC_Y = 156;
    private static final int ICON_SIZE = 20;
    private static final int TYPE_LOCATION_X = 180;
    private static final int TYPE_LOCATION_Y = 50;
    private static final int TYPE_SPACING_X = 47;
    private static final int TYPE_SPACING_Y = 30;
    private static final int TYPE_TEXT_WIDTH = 15;
    private static final int TEXT_OFFSET_X = 28;
    private static final int TEXT_OFFSET_Y = 7;
    private static final int PLAYERS_X = 20;
    private static final int PLAYERS_Y = 20;
    private static final int PLAYERS_SPACING = 20;
    private static final int DEATHS_RIGHT = 140;
    private static final String BEST_LABEL = "hqm.deathMenu.showWorst";
    private static final String TOTAL_LABEL = "hqm.deathMenu.showTotal";
    private static final int BEST_X = 185;
    private static final int TOTAL_X = 255;
    private static final int LABEL_Y = 210;
    private static final int VISIBLE_PLAYERS = 10;
    private final GuiQuestBook gui;
    private final ExtendedScrollBar<DeathStat> scrollBar;
    private UUID playerId;
    private boolean showTotal;
    private boolean showBest;

    public DeathStatsGraphic(GuiQuestBook guiQuestBook) {
        this.gui = guiQuestBook;
        this.scrollBar = new ExtendedScrollBar(guiQuestBook, ScrollBar.Size.LONG, 160, 18, 20, 10, () -> DeathStatsManager.getInstance().getDeathStats());
        this.addScrollBar(this.scrollBar);
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        List<DeathStat> deathStats = DeathStatsManager.getInstance().getDeathStats();
        int statY = 20;
        for (DeathStat stats : this.scrollBar.getVisibleEntries()) {
            boolean selected = stats.getUuid().equals(this.playerId);
            boolean inBounds = this.gui.inBounds(20, statY, 130, 9, mX, mY);
            this.gui.drawString(graphics, (FormattedText)Translator.text(deathStats.indexOf(stats) + 1 + ". ").m_7220_((Component)stats.getName()), 20, statY, this.getColor(selected, inBounds));
            String deaths = String.valueOf(stats.getTotalDeaths());
            this.gui.drawString(graphics, Translator.plain(deaths), 140 - this.gui.getStringWidth(deaths), statY, 0x404040);
            statY += 20;
        }
        this.gui.drawString(graphics, (FormattedText)Translator.translatable(BEST_LABEL, new Object[0]), 185, 210, this.getColor(this.showBest, this.gui.inBounds(185, 210, this.gui.getStringWidth(BEST_LABEL), 9, mX, mY)));
        this.gui.drawString(graphics, (FormattedText)Translator.translatable(TOTAL_LABEL, new Object[0]), 255, 210, this.getColor(this.showTotal, this.gui.inBounds(255, 210, this.gui.getStringWidth(TOTAL_LABEL), 9, mX, mY)));
        DeathStat stats = this.getDeathStat();
        if (stats != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int i = 0; i < DeathType.values().length; ++i) {
                int x = i % 3;
                int y = i / 3;
                this.gui.drawRect(graphics, GuiBase.MAP_TEXTURE, 180 + 47 * x, 50 + 30 * y, 234, 55, 22, 22);
                this.gui.drawRect(graphics, GuiBase.MAP_TEXTURE, 180 + 47 * x + 1, 50 + 30 * y + 1, 179 + 20 * x, 156 + 20 * y, 20, 20);
            }
            this.gui.drawString(graphics, (FormattedText)stats.getName(), 180, 20, 0x404040);
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.deathMenu.total", stats.getTotalDeaths()), 180, 32, 0.7f, 0x404040);
            for (DeathType type : DeathType.values()) {
                int i = type.ordinal();
                int x = i % 3;
                int y = i / 3;
                FormattedText text = Translator.plain("" + stats.getDeaths(type));
                float f = this.findScale(text);
                if (15.0f < f * (float)this.gui.getFont().m_92852_(text)) {
                    text = Translator.translatable("hqm.deathMenu.lots", new Object[0]);
                    f = this.findScale(text);
                }
                int offset = f == 1.0f ? 0 : Math.round(9.0f * (1.0f - f) - 1.0f);
                this.gui.drawString(graphics, text, 180 + 47 * x + 28, 50 + 30 * y + 7 + offset, f, 0x404040);
            }
        }
    }

    private float findScale(FormattedText text) {
        int width = this.gui.getFont().m_92852_(text);
        if (width <= 15) {
            return 1.0f;
        }
        if (0.8f * (float)width <= 15.0f) {
            return 0.8f;
        }
        if (0.6f * (float)width <= 15.0f) {
            return 0.6f;
        }
        return 0.4f;
    }

    @Override
    public void drawTooltip(GuiGraphics graphics, int mX, int mY) {
        super.drawTooltip(graphics, mX, mY);
        DeathStat stats = this.getDeathStat();
        if (stats != null) {
            for (DeathType type : DeathType.values()) {
                int y;
                int i = type.ordinal();
                int x = i % 3;
                if (!this.gui.inBounds(180 + 47 * x, 50 + 30 * (y = i / 3), 22, 22, mX, mY)) continue;
                this.gui.renderTooltipL(graphics, stats.getDescription(type), mX + this.gui.getLeft(), mY + this.gui.getTop());
                break;
            }
        }
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        super.onClick(mX, mY, b);
        if (this.gui.inBounds(185, 210, this.gui.getStringWidth((FormattedText)Translator.translatable(BEST_LABEL, new Object[0])), 9, mX, mY)) {
            this.showBest = !this.showBest;
            this.showTotal = false;
            this.playerId = null;
        } else if (this.gui.inBounds(255, 210, this.gui.getStringWidth((FormattedText)Translator.translatable(TOTAL_LABEL, new Object[0])), 9, mX, mY)) {
            this.showBest = false;
            this.showTotal = !this.showTotal;
            this.playerId = null;
        } else {
            this.showTotal = false;
            this.showBest = false;
            int statY = 20;
            for (DeathStat stats : this.scrollBar.getVisibleEntries()) {
                if (this.gui.inBounds(20, statY, 130, 9, mX, mY)) {
                    this.playerId = stats.getUuid().equals(this.playerId) ? null : stats.getUuid();
                }
                statY += 20;
            }
        }
    }

    private DeathStat getDeathStat() {
        DeathStatsManager manager = DeathStatsManager.getInstance();
        if (this.showBest) {
            return manager.getBest();
        }
        if (this.showTotal) {
            return manager.getTotal();
        }
        if (this.playerId != null) {
            return manager.getDeathStat(this.playerId);
        }
        return null;
    }

    private int getColor(boolean selected, boolean inBounds) {
        return selected ? (inBounds ? 0xC0C0C0 : 0xA0A0A0) : (inBounds ? 0x707070 : 0x404040);
    }
}

