/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic;

import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.bag.BagTier;
import hardcorequesting.common.forge.bag.GroupTier;
import hardcorequesting.common.forge.bag.GroupTierManager;
import hardcorequesting.common.forge.bag.LootGroup;
import hardcorequesting.common.forge.bag.TierColor;
import hardcorequesting.common.forge.client.BookPage;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.EditBagTierMenu;
import hardcorequesting.common.forge.client.interfaces.edit.WrappedTextMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.EditableGraphic;
import hardcorequesting.common.forge.client.interfaces.widget.ExtendedScrollBar;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.client.interfaces.widget.ScrollBar;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EditBagsGraphic
extends EditableGraphic {
    public static final int TIERS_X = 180;
    public static final int TIERS_Y = 20;
    public static final int TIERS_SPACING = 25;
    public static final int TIERS_SECOND_LINE_X = -5;
    public static final int TIERS_SECOND_LINE_Y = 12;
    public static final int WEIGHT_SPACING = 25;
    public static final int VISIBLE_TIERS = 8;
    public static final int GROUPS_X = 20;
    public static final int GROUPS_Y = 20;
    public static final int GROUPS_SPACING = 25;
    public static final int GROUPS_SECOND_LINE_X = 5;
    public static final int GROUPS_SECOND_LINE_Y = 12;
    public static final int VISIBLE_GROUPS = 8;
    private final BookPage.BagsPage page;
    private final ExtendedScrollBar<LootGroup> groupScroll;
    private final ExtendedScrollBar<GroupTier> tierScroll;
    private LootGroup selectedGroup;

    public EditBagsGraphic(BookPage.BagsPage page, GuiQuestBook gui) {
        super(gui, EditMode.NORMAL, EditMode.CREATE, EditMode.RENAME, EditMode.TIER, EditMode.DELETE);
        this.addClickable(new LargeButton(this.gui, "hqm.questBook.createGroup", 100, 175){

            @Override
            public boolean isVisible() {
                return EditBagsGraphic.this.gui.getCurrentMode() == EditMode.CREATE;
            }

            @Override
            public void onClick() {
                LootGroup.add(new LootGroup(null));
                SaveHelper.add(EditType.GROUP_CREATE);
            }
        });
        this.addClickable(new LargeButton(this.gui, "hqm.questBook.createTier", 100, 200){

            @Override
            public boolean isVisible() {
                return EditBagsGraphic.this.gui.getCurrentMode() == EditMode.CREATE;
            }

            @Override
            public void onClick() {
                GroupTierManager.getInstance().getTiers().add(new GroupTier("New Tier", TierColor.BLACK, 0, 0, 0, 0, 0));
                SaveHelper.add(EditType.TIER_CREATE);
            }
        });
        this.page = page;
        this.groupScroll = new ExtendedScrollBar(gui, ScrollBar.Size.LONG, 160, 18, 20, 8, () -> new ArrayList<LootGroup>(LootGroup.getGroups().values()));
        this.addScrollBar(this.groupScroll);
        this.tierScroll = new ExtendedScrollBar(gui, ScrollBar.Size.LONG, 312, 18, 180, 8, () -> GroupTierManager.getInstance().getTiers());
        this.addScrollBar(this.tierScroll);
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        int color;
        boolean inBounds;
        Component str;
        super.draw(graphics, mX, mY);
        int yPos = 20;
        for (GroupTier groupTier : this.tierScroll.getVisibleEntries()) {
            str = groupTier.getName();
            inBounds = this.gui.inBounds(180, yPos, this.gui.getStringWidth((FormattedText)str), 9, mX, mY);
            color = groupTier.getColor().getHexColor();
            if (inBounds) {
                color &= 0xFFFFFF;
                color |= 0xBB000000;
                RenderSystem.enableBlend();
            }
            this.gui.drawString(graphics, (FormattedText)str, 180, yPos, color);
            if (inBounds) {
                RenderSystem.disableBlend();
            }
            for (int j = 0; j < BagTier.values().length; ++j) {
                BagTier bagTier = BagTier.values()[j];
                this.gui.drawCenteredString(graphics, (FormattedText)Translator.text("" + groupTier.getWeights()[j]).m_130940_(bagTier.getColor()), 175 + j * 25, yPos + 12, 0.7f, 25, 0, 0x404040);
            }
            yPos += 25;
        }
        yPos = 20;
        for (LootGroup group : this.groupScroll.getVisibleEntries()) {
            boolean selected;
            str = group.getDisplayName();
            inBounds = this.gui.inBounds(20, yPos, this.gui.getStringWidth((FormattedText)str), 9, mX, mY);
            color = group.getTier().getColor().getHexColor();
            boolean bl = selected = group == this.selectedGroup;
            if (inBounds || selected) {
                color &= 0xFFFFFF;
                RenderSystem.enableBlend();
                color = selected ? (color |= 0x50000000) : (color |= 0xBB000000);
            }
            this.gui.drawString(graphics, (FormattedText)str, 20, yPos, color);
            if (inBounds || selected) {
                RenderSystem.disableBlend();
            }
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.questBook.items", group.getItems().size()), 25, yPos + 12, 0.7f, 0x404040);
            yPos += 25;
        }
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        super.onClick(mX, mY, button);
        int posY = 20;
        for (LootGroup group : this.groupScroll.getVisibleEntries()) {
            if (this.gui.inBounds(20, posY, this.gui.getStringWidth(group.getDisplayName()), 9, mX, mY)) {
                switch (this.gui.getCurrentMode()) {
                    case TIER: {
                        this.selectedGroup = group == this.selectedGroup ? null : group;
                        break;
                    }
                    case NORMAL: {
                        this.gui.setPage(this.page.forGroup(group));
                        break;
                    }
                    case RENAME: {
                        WrappedTextMenu.displayWithOptionalResult(this.gui, group.getRawName(), true, text -> group.setName(text.orElse(null)));
                        break;
                    }
                    case DELETE: {
                        LootGroup.remove(group.getId());
                        SaveHelper.add(EditType.GROUP_REMOVE);
                        break;
                    }
                }
                break;
            }
            posY += 25;
        }
        posY = 20;
        block13: for (GroupTier groupTier : this.tierScroll.getVisibleEntries()) {
            if (this.gui.inBounds(180, posY, this.gui.getStringWidth((FormattedText)groupTier.getName()), 9, mX, mY)) {
                switch (this.gui.getCurrentMode()) {
                    case TIER: {
                        if (this.selectedGroup == null) break block13;
                        this.selectedGroup.setTier(groupTier);
                        SaveHelper.add(EditType.GROUP_CHANGE);
                        break;
                    }
                    case NORMAL: {
                        EditBagTierMenu.display(this.gui, groupTier);
                        break;
                    }
                    case RENAME: {
                        WrappedTextMenu.display(this.gui, groupTier.getRawName(), 110, groupTier::setName);
                        break;
                    }
                    case DELETE: {
                        if (!EditBagsGraphic.replaceUseOfTier(groupTier)) break block13;
                        GroupTierManager.getInstance().getTiers().remove(groupTier);
                        SaveHelper.add(EditType.TIER_REMOVE);
                        break;
                    }
                }
                break;
            }
            posY += 25;
        }
    }

    private static boolean replaceUseOfTier(GroupTier groupTier) {
        if (LootGroup.getGroups().size() > 0) {
            List<GroupTier> tiers = GroupTierManager.getInstance().getTiers();
            if (tiers.size() <= 1) {
                return false;
            }
            GroupTier replacementTier = tiers.get(0);
            if (replacementTier == groupTier) {
                replacementTier = tiers.get(1);
            }
            for (LootGroup group : LootGroup.getGroups().values()) {
                if (group.getTier() != groupTier) continue;
                group.setTier(replacementTier);
            }
        }
        return true;
    }

    @Override
    protected void setEditMode(EditMode mode) {
        if (mode != EditMode.TIER) {
            this.selectedGroup = null;
        }
        super.setEditMode(mode);
    }
}

